/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.throttler;

import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.handler.throttler.ConnectionThrottler;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ExchangeThrottler
extends ConnectionThrottler {
    private final Map<InetAddress, AtomicInteger> connections = new ConcurrentHashMap<InetAddress, AtomicInteger>();

    @Override
    final boolean addConnection(SimpleHttpExchange exchange) {
        InetAddress address = exchange.getRemoteAddress().getAddress();
        int maxConn = this.getMaxConnections(exchange);
        this.connections.putIfAbsent(address, new AtomicInteger(0));
        AtomicInteger conn = this.connections.get(address);
        if (maxConn < 0) {
            conn.incrementAndGet();
            return true;
        }
        AtomicBoolean added = new AtomicBoolean(false);
        conn.updateAndGet(operand -> {
            if (operand < maxConn) {
                added.set(true);
            }
            return operand < maxConn ? operand + 1 : operand;
        });
        return added.get();
    }

    @Override
    final void deleteConnection(SimpleHttpExchange exchange) {
        InetAddress address = exchange.getRemoteAddress().getAddress();
        if (this.connections.containsKey(address)) {
            this.connections.get(address).decrementAndGet();
        }
    }

    @Override
    public int getMaxConnections(SimpleHttpExchange exchange) {
        return 0;
    }

    public String toString() {
        return "ExchangeThrottler{connections=" + this.connections + '}';
    }
}

