/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver;

import dev.katsute.simplehttpserver.Record;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class FileRecord
extends Record {
    final String fileName = Objects.requireNonNull(Objects.requireNonNull(this.getHeader("Content-Disposition").getParameter("filename")));
    final String contentType = Objects.requireNonNull(Objects.requireNonNull(this.getHeader("Content-Type")).getValue());
    private final byte[] bytes = this.getValue().getBytes(StandardCharsets.UTF_8);

    FileRecord(Map.Entry<String, Map<String, ?>> entry) {
        super(entry);
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    @Override
    public String toString() {
        return "FileRecord{fileName='" + this.fileName + '\'' + ", contentType='" + this.contentType + '\'' + ", bytes=" + Arrays.toString(this.bytes) + '}';
    }
}

