/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.file;

import dev.katsute.simplehttpserver.handler.file.FileAdapter;
import dev.katsute.simplehttpserver.handler.file.FileOptions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

final class FileEntry {
    private final File file;
    private final Path path;
    private final FileAdapter adapter;
    private final FileOptions options;
    private byte[] bytes = null;
    private final AtomicLong lastModified = new AtomicLong();
    private final AtomicLong expiry = new AtomicLong(-1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileEntry(File file, FileAdapter fileAdapter, FileOptions options) {
        this.file = file;
        this.path = file.toPath();
        this.adapter = fileAdapter;
        this.options = options;
        if (options.loading == FileOptions.FileLoadingOption.PRELOAD || options.loading == FileOptions.FileLoadingOption.MODIFY) {
            try {
                this.bytes = this.adapter.getBytes(file, Files.readAllBytes(this.path));
            }
            catch (Throwable ignored) {
                this.bytes = null;
            }
            finally {
                if (options.loading == FileOptions.FileLoadingOption.MODIFY) {
                    this.lastModified.set(file.lastModified());
                }
            }
        }
    }

    final File getFile() {
        return this.file;
    }

    final synchronized void reloadBytes() {
        switch (this.options.loading) {
            default: {
                throw new UnsupportedOperationException("Reload is only supported for CACHE and MODIFY options");
            }
            case MODIFY: {
                this.lastModified.set(this.file.lastModified());
            }
            case CACHE: 
        }
        this.expiry.getAndUpdate(was -> System.currentTimeMillis() + this.options.cache);
        try {
            this.bytes = this.adapter.getBytes(this.file, Files.readAllBytes(this.path));
        }
        catch (Throwable ignored) {
            this.bytes = null;
        }
    }

    final synchronized void clearBytes() {
        switch (this.options.loading) {
            default: {
                throw new UnsupportedOperationException("Clear is only supported for CACHE and MODIFY options");
            }
            case MODIFY: {
                this.lastModified.set(-1L);
            }
            case CACHE: 
        }
        this.bytes = null;
    }

    final byte[] getBytes() {
        switch (this.options.loading) {
            case PRELOAD: {
                return this.bytes;
            }
            default: {
                try {
                    return this.adapter.getBytes(this.file, Files.readAllBytes(this.path));
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            case MODIFY: {
                if (this.file.lastModified() != this.lastModified.get()) {
                    this.reloadBytes();
                }
                return this.bytes;
            }
            case CACHE: 
        }
        if (this.bytes == null || this.isExpired()) {
            this.reloadBytes();
        }
        return this.bytes;
    }

    final boolean isExpired() {
        return this.options.loading == FileOptions.FileLoadingOption.CACHE && this.expiry.get() < System.currentTimeMillis();
    }

    public String toString() {
        return "FileEntry{file=" + this.file + ", path=" + this.path + ", adapter=" + this.adapter + ", options=" + this.options + ", bytes=" + Arrays.toString(this.bytes) + ", lastModified=" + this.lastModified + ", expiry=" + this.expiry + ", expired=" + this.isExpired() + '}';
    }
}

