/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry;

import dev.secondsun.geometry.Triangle;
import java.util.Objects;

public class EdgeEntry {
    public int startX;
    public int endX;
    public float z;
    public float textureVectorX;
    public float textureVectorY;
    public float textureVectorLength;
    public int textureId;
    public Triangle triangle;

    public EdgeEntry(int startX, int endX, float z, float textureVectorX, float textureVectorY, float textureVectorLength, int textureId, Triangle triangle) {
        if (endX - startX < 0) {
            System.err.println("negative length startX:" + startX + " endX:" + endX);
            this.startX = -1;
            this.endX = -1;
            throw new RuntimeException("negative length startX:" + startX + " endX:" + endX);
        }
        this.startX = startX;
        this.endX = endX;
        this.z = z;
        this.textureVectorX = textureVectorX;
        this.textureVectorY = textureVectorY;
        this.textureVectorLength = textureVectorLength;
        this.textureId = textureId;
        this.triangle = triangle;
    }

    public String toString() {
        return "EdgeEntry{startX=" + this.startX + ", endX=" + this.endX + ", z=" + this.z + ", textureVectorX=" + this.textureVectorX + ", textureVectorY=" + this.textureVectorY + ", textureVectorLength=" + this.textureVectorLength + ", textureId=" + this.textureId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeEntry edgeEntry = (EdgeEntry)o;
        return this.startX == edgeEntry.startX && this.endX == edgeEntry.endX && Float.compare(edgeEntry.z, this.z) == 0 && Float.compare(edgeEntry.textureVectorX, this.textureVectorX) == 0 && Float.compare(edgeEntry.textureVectorY, this.textureVectorY) == 0 && Float.compare(edgeEntry.textureVectorLength, this.textureVectorLength) == 0 && this.textureId == edgeEntry.textureId;
    }

    public int hashCode() {
        return Objects.hash(this.startX, this.endX, Float.valueOf(this.z), Float.valueOf(this.textureVectorX), Float.valueOf(this.textureVectorY), Float.valueOf(this.textureVectorLength), this.textureId);
    }
}

