/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.util;

import dev.secondsun.geometry.Camera;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import dev.secondsun.util.BoundedCube;
import dev.secondsun.util.Plane;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BSPTree {
    private Node root;

    public BSPTree() {
    }

    public void add(BoundedCube object) {
        if (this.root == null) {
            this.root = new Node(object);
        } else {
            this.root.add(object);
        }
    }

    public List<Triangle> order(Camera camera) {
        ArrayList<Triangle> toReturn = new ArrayList<Triangle>();
        List<BoundedCube> modelsInOrder = this.getModelsInOrderFrom(this.getRoot(), camera);
        toReturn.addAll(modelsInOrder.stream().flatMap(boundedCube -> boundedCube.model.getTriangles().stream()).collect(Collectors.toList()));
        return toReturn;
    }

    public List<BoundedCube> getModelsInOrderFrom(Node node, Camera camera) {
        ArrayList<BoundedCube> cubes = new ArrayList<BoundedCube>();
        if (node.bounds != null) {
            cubes.add(node.bounds);
        } else if (camera.getFrom().isBehind(node.partition)) {
            cubes.addAll(this.getModelsInOrderFrom(node.behind, camera));
            cubes.addAll(this.getModelsInOrderFrom(node.front, camera));
        } else {
            cubes.addAll(this.getModelsInOrderFrom(node.front, camera));
            cubes.addAll(this.getModelsInOrderFrom(node.behind, camera));
        }
        return cubes;
    }

    public BSPTree(Node root) {
        this.root = root;
    }

    public Node getRoot() {
        return this.root;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BSPTree other = (BSPTree)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    public static class Node {
        public Node behind;
        public Node front;
        public Plane partition;
        public BoundedCube bounds;

        public Node(BoundedCube object) {
            this.add(object);
        }

        public Node() {
        }

        public void add(BoundedCube object) {
            if (this.partition == null && this.bounds == null) {
                this.bounds = object;
            } else if (this.partition == null) {
                BoundedCube behindObject = this.bounds;
                Plane foundPartition = this.findPartition(behindObject, object);
                this.bounds = null;
                this.partition = foundPartition;
                this.behind = new Node();
                this.behind.bounds = behindObject;
                this.front = new Node();
                this.front.bounds = object;
            } else {
                this.front.add(object);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.behind == null ? 0 : this.behind.hashCode());
            result = 31 * result + (this.bounds == null ? 0 : this.bounds.hashCode());
            result = 31 * result + (this.front == null ? 0 : this.front.hashCode());
            result = 31 * result + (this.partition == null ? 0 : this.partition.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            if (this.behind == null ? other.behind != null : !this.behind.equals(other.behind)) {
                return false;
            }
            if (this.bounds == null ? other.bounds != null : !this.bounds.equals(other.bounds)) {
                return false;
            }
            if (this.front == null ? other.front != null : !this.front.equals(other.front)) {
                return false;
            }
            return !(this.partition == null ? other.partition != null : !this.partition.equals(other.partition));
        }

        private Plane findPartition(BoundedCube behindObject, BoundedCube frontObject) {
            Plane nearTestPlane = new Plane(new Vertex(0.0f, 0.0f, behindObject.near), new Vertex(0.0f, 0.0f, 1.0f));
            Plane farTestPlane = new Plane(new Vertex(0.0f, 0.0f, behindObject.far), new Vertex(0.0f, 0.0f, -1.0f));
            Plane leftTestPlane = new Plane(new Vertex(behindObject.left, 0.0f, 0.0f), new Vertex(-1.0f, 0.0f, 0.0f));
            Plane rightTestPlane = new Plane(new Vertex(behindObject.right, 0.0f, 0.0f), new Vertex(1.0f, 0.0f, 0.0f));
            Plane topTestPlane = new Plane(new Vertex(0.0f, behindObject.top, 0.0f), new Vertex(0.0f, 1.0f, 0.0f));
            Plane bottomTestPlane = new Plane(new Vertex(0.0f, behindObject.bottom, 0.0f), new Vertex(0.0f, -1.0f, 0.0f));
            if (frontObject.isInFront(nearTestPlane)) {
                return nearTestPlane;
            }
            if (frontObject.isInFront(farTestPlane)) {
                return farTestPlane;
            }
            if (frontObject.isInFront(topTestPlane)) {
                return topTestPlane;
            }
            if (frontObject.isInFront(bottomTestPlane)) {
                return bottomTestPlane;
            }
            if (frontObject.isInFront(leftTestPlane)) {
                return leftTestPlane;
            }
            if (frontObject.isInFront(rightTestPlane)) {
                return rightTestPlane;
            }
            throw new IllegalStateException("can't place object" + behindObject.toString() + "\n" + frontObject.toString());
        }
    }
}

