/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.command;

import dev.tidalcode.wave.config.Config;
import dev.tidalcode.wave.data.IntervalTime;
import dev.tidalcode.wave.data.MaxTime;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CommandContext {
    private final int[] xyCordsArray = new int[2];
    private boolean isMultiple = false;
    private boolean isVisible = true;
    private String textInput;
    private String attributeName;
    private int selectIndex;
    private int tabIndex;
    private int hoverWaitTime;
    private double zoomLevel;
    private CharSequence[] sequence;
    private List<String> locators = new LinkedList<String>();
    private boolean shadowDomPresence;
    private int elementIndex;
    private boolean debugMode;
    private MaxTime maxTime;
    private IntervalTime intervalTime;
    private final StringBuilder sb = new StringBuilder("CommandContext{");

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public int getHoverWaitTime() {
        return this.hoverWaitTime;
    }

    public void setHoverWaitTime(int hoverWaitTime) {
        this.hoverWaitTime = hoverWaitTime;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public CharSequence[] getSequence() {
        return this.sequence;
    }

    public void setSequence(CharSequence ... sequence) {
        this.sequence = sequence;
    }

    public String getTextInput() {
        return this.textInput;
    }

    public void setTextInput(String textInput) {
        this.textInput = textInput;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
    }

    public boolean getVisibility() {
        return this.isVisible;
    }

    public void setVisibility(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public List<String> getLocators() {
        return this.locators;
    }

    public void setLocatorSet(List<String> locators) {
        this.locators = locators;
    }

    public void setXYCords(int xCords, int yCords) {
        this.xyCordsArray[0] = xCords;
        this.xyCordsArray[1] = yCords;
    }

    public int[] getXYCords() {
        return this.xyCordsArray;
    }

    public double getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(double zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public void setShadowDomPresence(boolean shadowDomPresence) {
        this.shadowDomPresence = shadowDomPresence;
    }

    public boolean getShadowDomPresence() {
        return this.shadowDomPresence;
    }

    public int getElementIndex() {
        return this.elementIndex;
    }

    public void setElementIndex(int elementIndex) {
        this.elementIndex = elementIndex;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public MaxTime getMaxRefreshTime() {
        return this.maxTime;
    }

    public IntervalTime getRefreshIntervalTime() {
        return this.intervalTime;
    }

    public void setMaxRefreshTime(MaxTime maxTime) {
        this.maxTime = maxTime;
    }

    public void setIntervalTime(IntervalTime intervalTime) {
        this.intervalTime = intervalTime;
    }

    public String toString() {
        int duration = Integer.parseInt(WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME));
        this.sb.append("\n xyCordsArray: ").append(Arrays.toString(this.xyCordsArray)).append(", \n Finding Multiple Elements:").append(this.isMultiple).append(", \n Looking for visible element:").append(this.isVisible).append("  \n Wait duration: ").append(duration).append(" seconds").append(", \n Text input:'").append(this.textInput).append(", \n Attribute Name:'").append(this.attributeName).append(", \n Select Index:").append(this.selectIndex).append(", \n Tab Index:").append(this.tabIndex).append(", \n Hover Wait Time:").append(this.hoverWaitTime).append(", \n Zoom Level:").append(this.zoomLevel).append(", \n Char Sequence Input:").append(Arrays.toString(this.sequence)).append(", \n Locators:").append(String.join((CharSequence)",", this.locators)).append(", \n Shadow DOM Check:").append(this.shadowDomPresence).append(", \n Element Index:").append(this.elementIndex).append(", \n Debug Mode:").append(this.debugMode || Config.DEBUG ? "true" : "false").append('}');
        return this.sb.toString();
    }
}

