/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public final class ClearAndType
extends CommandAction
implements Command<Void> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private CharSequence[] charSequences;
    Function<CommandContext, Void> function = e -> {
        Function<WebElement, String> expectedValue = w -> w.getDomAttribute("value");
        WebElement element = this.webElement.getElement(this.context);
        int currentCharsCount = expectedValue.apply(element).length();
        for (int i = 0; i < currentCharsCount; ++i) {
            element.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        }
        for (CharSequence c : this.charSequences) {
            element.sendKeys(new CharSequence[]{c});
        }
        return null;
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.charSequences = context.getSequence();
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, Void> getFunction() {
        return this.function;
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.Of.clear();
    }

    public void clearAndTypeAction() {
        this.function.apply(this.context);
    }

    public void clearAndType() {
        this.timeCounter.restart();
        super.execute(Commands.ClickCommands.CLEAR_AND_TYPE.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

