/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.google.common.base.Strings;
import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public final class FindTextData
extends CommandAction
implements Command<String> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    Function<CommandContext, String> function = e -> {
        WebElement element = this.webElement.getElement(this.context);
        String textContent = element.getText();
        if (!Strings.isNullOrEmpty((String)textContent)) {
            return textContent;
        }
        textContent = element.getDomAttribute("value");
        if (!Strings.isNullOrEmpty((String)textContent)) {
            return textContent;
        }
        textContent = element.getDomAttribute("innerHTML");
        if (!Strings.isNullOrEmpty((String)textContent)) {
            return textContent;
        }
        textContent = (String)((JavascriptExecutor)((RemoteWebElement)element).getWrappedDriver()).executeScript("return arguments[0].innerHTML;", new Object[]{element});
        if (!Strings.isNullOrEmpty((String)textContent)) {
            return textContent;
        }
        return "";
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, String> getFunction() {
        return this.function;
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public String findTextDataAction() {
        return this.function.apply(this.context);
    }

    public String findTextData() {
        this.timeCounter.restart();
        return (String)super.execute(Commands.GetCommands.FIND_TEXT_DATA.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

