/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;

public final class IsPresentAndVisible
extends CommandAction
implements Command<Boolean> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    Function<CommandContext, Boolean> function = e -> {
        List<WebElement> elements = this.webElement.getElements(this.context);
        return !elements.isEmpty() && elements.stream().anyMatch(WebElement::isDisplayed);
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        context.setVisibility(false);
        context.setMultiple(true);
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, Boolean> getFunction() {
        return this.function;
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public boolean isPresentAndVisibleAction() {
        return this.function.apply(this.context);
    }

    public boolean isPresentAndVisible() {
        this.timeCounter.restart();
        return (Boolean)super.execute(Commands.StateCheckCommands.IS_PRESENT_AND_DISPLAYED.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

