/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebElement;

public final class MoveByOffSet
extends CommandAction
implements Command<Void> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private int[] xyCords;
    Function<CommandContext, Void> function = e -> {
        WebElement element = this.webElement.getElement(this.context);
        new Actions(((RemoteWebElement)element).getWrappedDriver()).moveToElement(element, this.xyCords[0], this.xyCords[1]);
        return null;
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.xyCords = context.getXYCords();
        this.context.setVisibility(false);
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    protected Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.notInteractableAndStale();
    }

    @Override
    public Function<CommandContext, Void> getFunction() {
        return this.function;
    }

    public void moveByOffSetAction() {
        this.function.apply(this.context);
    }

    public void moveByOffSet() {
        this.timeCounter.restart();
        super.execute(Commands.MoveCommands.MOVE_BY_OFFSET.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

