/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.javascript.Scripts;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Property
extends CommandAction
implements Command<Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(Property.class);
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    Function<CommandContext, Map<String, Object>> function = e -> {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        WebElement element = this.webElement.getElement(this.context);
        properties.put("Is Enabled", element.isEnabled());
        properties.put("Is Visible", element.isDisplayed());
        Point location = element.getLocation();
        properties.put("Location", "X Coordinate: " + location.getX() + ", Y Coordinate " + location.getY());
        properties.put("Tag Name", element.getTagName());
        properties.put("Text Value", element.getText());
        properties.put("Is Selected", element.isSelected());
        Dimension dimension = element.getSize();
        properties.put("Dimension", "Height: " + dimension.getHeight() + " , Width: " + dimension.getWidth());
        properties.put("Accessible Name", element.getAccessibleName());
        properties.put("Aria Role", element.getAriaRole());
        properties.put("Attributes", ((JavascriptExecutor)((RemoteWebElement)element).getWrappedDriver()).executeScript(Scripts.getAttributes(), new Object[]{element}));
        return properties;
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, Map<String, Object>> getFunction() {
        return this.function;
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public void propertyAction() {
        this.function.apply(this.context).forEach((k, v) -> logger.info(k.toUpperCase() + " = " + String.valueOf(v)));
    }

    public void property() {
        this.timeCounter.restart();
        super.execute("propertyAction", this.ignoredExceptions, this.timeCounter);
    }
}

