/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.exceptions.SetTextException;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public final class SetText
extends CommandAction
implements Command<Void> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private TimeCounter timeCounter;
    private String inputText;
    Function<CommandContext, Void> function = e -> {
        WebElement element;
        Function<WebElement, String> currentInputValue;
        if (this.timeCounter == null) {
            this.timeCounter = new TimeCounter();
        }
        if (!(currentInputValue = w -> w.getDomAttribute("value")).apply(element = this.webElement.getElement(this.context)).equals(this.inputText)) {
            element.sendKeys(new CharSequence[]{this.inputText});
        }
        if (this.timeCounter.timeElapsed(Duration.ofSeconds(2L))) {
            int existingCharsLength = currentInputValue.apply(element).length();
            for (int i = 0; i < existingCharsLength; ++i) {
                element.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            }
            element.sendKeys(new CharSequence[]{this.inputText});
        }
        if (!currentInputValue.apply(element).equals(this.inputText)) {
            element.clear();
            throw new SetTextException("Error when tried to input text using setText method");
        }
        this.timeCounter = null;
        return null;
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.inputText = context.getTextInput();
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, Void> getFunction() {
        return this.function;
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.Of.sendKeys();
    }

    public void setTextAction() {
        this.function.apply(this.context);
    }

    public void setText() {
        this.timeCounter = new TimeCounter();
        super.execute(Commands.InputCommands.SET_TEXT.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

