/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.data.tabular;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularDataParser {
    Logger logger = LoggerFactory.getLogger(TabularDataParser.class);

    public List<String> asList(String tableData) {
        LinkedList<String> data = new LinkedList<String>();
        Document doc = Jsoup.parse((String)tableData);
        Element table = doc.select("table").first();
        if (null == table) {
            this.logger.info("NO TABLE IS FOUND");
        }
        Elements rows = table.select("tr");
        for (Element row : rows) {
            Elements cells = row.select("td");
            for (Element cell : cells) {
                data.add(cell.text() + "\t");
            }
        }
        return data;
    }

    public List<Map<String, String>> asTableList(String htmlTable) {
        Document doc = Jsoup.parse((String)htmlTable);
        Element table = doc.select("table").first();
        if (null == table) {
            this.logger.info("NO TABLE IS FOUND");
            return null;
        }
        Elements rows = table.select("tbody tr");
        ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
        for (Element row : rows) {
            Elements cells = row.select("td,th");
            Hashtable<String, String> rowData = new Hashtable<String, String>();
            for (int i = 0; i < cells.size(); ++i) {
                Element cell = (Element)cells.get(i);
                String header = cell.attr("scope");
                String columnName = header.isEmpty() ? "Column" + (i + 1) : header;
                rowData.put(columnName, cell.text());
            }
            tableData.add(rowData);
        }
        return tableData;
    }
}

