/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.verification.conditions;

import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.commands.FindTextData;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import dev.tidalcode.wave.exceptions.TestAssertionError;
import dev.tidalcode.wave.verification.conditions.Condition;
import dev.tidalcode.wave.wait.FluentWait;
import java.time.Duration;
import org.openqa.selenium.StaleElementReferenceException;

public class IgnoreCaseExactTextCondition
extends Condition {
    private final String value;

    public IgnoreCaseExactTextCondition(String value) {
        this.value = value;
    }

    @Override
    public void verify(Executor executor) {
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        new FluentWait<Executor>(executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(StaleElementReferenceException.class).throwing(TestAssertionError.class).withMessage(String.format("Expected value '%s' is not same as actual value '%s'", this.value, executor.invokeCommand(FindTextData.class, "findTextData"))).until(e -> e.invokeCommand(FindTextData.class, "findTextData").toString().equalsIgnoreCase(this.value));
    }
}

