/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.verification.conditions.collections;

import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.commands.GetSize;
import dev.tidalcode.wave.verification.conditions.collections.CollectionsCondition;
import dev.tidalcode.wave.wait.FluentWait;
import java.time.Duration;

public class CollectionSizeLessThan
extends CollectionsCondition {
    private final int value;

    public CollectionSizeLessThan(int value) {
        this.value = value;
    }

    @Override
    public void verify(Executor executor) {
        Duration waitDuration = Duration.ofSeconds(1L);
        new FluentWait<Executor>(executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).withMessage(String.format("Expected number of elements is less than %d but found %d element[s]", this.value, (int)((Integer)executor.invokeCommand(GetSize.class, "getSize")))).until(e -> (Integer)e.invokeCommand(GetSize.class, "getSize") < this.value);
    }
}

