/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.verification.expectations;

import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.commands.FindTextData;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import dev.tidalcode.wave.exceptions.TimeoutException;
import dev.tidalcode.wave.verification.expectations.Expectation;
import dev.tidalcode.wave.wait.FluentWait;
import java.time.Duration;
import org.openqa.selenium.StaleElementReferenceException;

public class ExactTextExpectation
extends Expectation {
    private static final String FIND_TEXT_DATA = "findTextData";
    private final String value;
    private Executor executor;

    public ExactTextExpectation(String value) {
        this.value = value;
    }

    @Override
    public void assertion(Executor executor) {
        this.executor = executor;
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        this.result = new FluentWait<Executor>(executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Expected value '%s' is not equal to actual value %s", this.value, executor.invokeCommand(FindTextData.class, FIND_TEXT_DATA))).until(e -> e.invokeCommand(FindTextData.class, FIND_TEXT_DATA).equals(this.value));
    }

    @Override
    public void orElseFail() {
        super.orElseFail(String.format("Expected value '%s' is not equal to actual value %s", this.value, this.executor.invokeCommand(FindTextData.class, FIND_TEXT_DATA)));
    }
}

