/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.verification.expectations;

import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.commands.IsVisible;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import dev.tidalcode.wave.exceptions.TimeoutException;
import dev.tidalcode.wave.verification.expectations.Expectation;
import dev.tidalcode.wave.wait.FluentWait;
import java.time.Duration;
import org.openqa.selenium.StaleElementReferenceException;

public class VisibleExpectation
extends Expectation {
    private String byLocator;

    @Override
    public void assertion(Executor executor) {
        this.byLocator = executor.getContext().getLocators().get(executor.getContext().getLocators().size() - 1);
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        this.result = new FluentWait<Executor>(executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Element %s expected to be visible but was not", this.byLocator)).until(e -> (Boolean)e.invokeCommand(IsVisible.class, "isVisible"));
    }

    @Override
    public void orElseFail() {
        super.orElseFail(String.format("Expected condition failed : Element %s expected to be visible but was not", this.byLocator));
    }
}

