/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.webelement;

import dev.tidalcode.wave.browser.Driver;
import dev.tidalcode.wave.wait.Wait;
import dev.tidalcode.wave.webelement.UIActions;
import dev.tidalcode.wave.webelement.UIElement;
import dev.tidalcode.wave.webelement.UIElements;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.locators.RelativeLocator;

public class ElementFinder<T> {
    private ElementFinder() {
    }

    public static UIElement find(String locator) {
        Objects.requireNonNull(locator, "Locator needs to be set to find an element");
        return new UIActions().setProperties(locator).withDefaultWait();
    }

    public static WebElement find(RelativeLocator.RelativeBy relativeBy) {
        Objects.requireNonNull(relativeBy, "Locator needs to be set to find an element");
        Wait.setDefaultWait();
        return Driver.getDriver().findElement((By)relativeBy);
    }

    public static UIElements findAll(String locator) {
        Objects.requireNonNull(locator, "Locator needs to be set to find an element");
        return new UIElements().setProperties(locator).withDefaultWait();
    }
}

