/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.customplugin;

import eu.miaplatform.crud.library.CRUD;
import eu.miaplatform.crud.library.GET;
import eu.miaplatform.crud.library.POST;
import eu.miaplatform.crud.library.QueryBuilder;
import eu.miaplatform.crud.library.annotations.CollectionAnnotation;
import eu.miaplatform.crud.library.enums.State;
import eu.miaplatform.customplugin.CRUDServiceClient;
import eu.miaplatform.customplugin.CustomPluginHeader;
import eu.miaplatform.customplugin.CustomPluginHeadersPropagator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRUDServiceClientImpl
implements CRUDServiceClient {
    private CRUD crud;
    private Logger logger = LoggerFactory.getLogger(CRUDServiceClientImpl.class);

    private CRUDServiceClientImpl(String apiPath, String apiSecret) {
        this.crud = apiPath != null ? new CRUD(apiPath) : new CRUD();
        if (apiSecret != null) {
            this.crud.getNetwork().addInterceptor(chain -> {
                Request request = chain.request();
                if (!request.headers().names().contains("secret")) {
                    request = request.newBuilder().addHeader("secret", apiSecret).build();
                }
                return chain.proceed(request);
            });
        }
    }

    CRUDServiceClientImpl(String apiPath, String apiSecret, CustomPluginHeadersPropagator headersPropagator) {
        this(apiPath, apiSecret);
        this.addAddHeadersInterceptor(headersPropagator);
    }

    CRUDServiceClientImpl(String apiPath, String apiSecret, int version, CustomPluginHeadersPropagator headersPropagator) {
        this(apiPath, apiSecret, headersPropagator);
        this.crud.setVersion(version);
    }

    private void addAddHeadersInterceptor(CustomPluginHeadersPropagator headersPropagator) {
        if (headersPropagator != null && headersPropagator.getHeaders() != null && headersPropagator.getHeaders().size() > 0) {
            List<CustomPluginHeader> headers = headersPropagator.getHeaders();
            this.crud.getNetwork().addInterceptor(chain -> {
                Request request = chain.request();
                Request.Builder builder = request.newBuilder();
                headers.forEach(customPluginHeader -> {
                    if (request.headers().names().contains(customPluginHeader.getName())) {
                        builder.removeHeader(customPluginHeader.getName());
                    }
                    builder.addHeader(customPluginHeader.getName(), customPluginHeader.getValue());
                });
                Request newRequest = builder.build();
                return chain.proceed(newRequest);
            });
        }
    }

    @Override
    public <T extends Serializable> Stream<T> retrieveAll(Class<T> clazz) {
        GET get = this.crud.get(clazz.getAnnotation(CollectionAnnotation.class).collectionName(), (QueryBuilder)null);
        return Objects.requireNonNull(get.sync(clazz)).stream();
    }

    @Override
    public <T extends Serializable> T retrieveById(String id, Class<T> clazz) {
        GET get = this.crud.get(clazz.getAnnotation(CollectionAnnotation.class).collectionName(), "");
        return get.sync(id, clazz);
    }

    @Override
    public <T extends Serializable> Stream<T> retrieveByAttribute(String attributeName, String attribute, Class<T> clazz) {
        GET get = this.crud.get(clazz.getAnnotation(CollectionAnnotation.class).collectionName(), new QueryBuilder().equals(attributeName, attribute));
        return Objects.requireNonNull(get.sync(clazz)).stream();
    }

    @Override
    public <T extends Serializable> Stream<T> retrieveByQuery(QueryBuilder queryBuilder, Class<T> clazz) {
        GET get = this.crud.get(clazz.getAnnotation(CollectionAnnotation.class).collectionName(), queryBuilder);
        return Objects.requireNonNull(get.sync(clazz)).stream();
    }

    @Override
    public <T extends Serializable> String storeSingle(T obj, Class<T> clazz) {
        POST post = this.crud.post(clazz.getAnnotation(CollectionAnnotation.class).collectionName());
        return post.sync(obj, State.Pub);
    }

    @Override
    public <T extends Serializable> Stream<String> storeMulti(Stream<T> objs, Class<T> clazz) {
        POST post = this.crud.post(clazz.getAnnotation(CollectionAnnotation.class).collectionName());
        ArrayList objsList = objs.collect(Collectors.toCollection(ArrayList::new));
        return Objects.requireNonNull(post.sync(objsList, State.Pub)).stream();
    }
}

