/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.crud.library;

import com.google.gson.JsonElement;
import eu.miaplatform.crud.library.CRUDError;
import eu.miaplatform.crud.library.DELETE;
import eu.miaplatform.crud.library.Network;
import eu.miaplatform.crud.library.QueryBuilder;
import eu.miaplatform.crud.library.enums.Parameters;
import eu.miaplatform.crud.library.enums.State;
import eu.miaplatform.crud.library.listeners.NoObjectCallback;
import eu.miaplatform.crud.library.listeners.SingleObjectCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0003H\u0002J\u000e\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0017J\u001e\u0010\u000f\u001a\u00020\u00112\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0018j\b\u0012\u0004\u0012\u00020\u0017`\u0019J\r\u0010\u001a\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Leu/miaplatform/crud/library/DELETE;", "", "collection", "", "query", "network", "Leu/miaplatform/crud/library/Network;", "crudVersion", "", "(Ljava/lang/String;Ljava/lang/String;Leu/miaplatform/crud/library/Network;Ljava/lang/Integer;)V", "queryBuilder", "Leu/miaplatform/crud/library/QueryBuilder;", "(Ljava/lang/String;Leu/miaplatform/crud/library/QueryBuilder;Leu/miaplatform/crud/library/Network;Ljava/lang/Integer;)V", "(Ljava/lang/String;Leu/miaplatform/crud/library/Network;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "state", "async", "", "callback", "Leu/miaplatform/crud/library/listeners/SingleObjectCallback;", "id", "Leu/miaplatform/crud/library/listeners/NoObjectCallback;", "getQueryParameters", "Leu/miaplatform/crud/library/enums/State;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "sync", "()Ljava/lang/Integer;", "custom-plugin-java"})
public final class DELETE {
    private String query;
    private String state;
    private final String collection;
    private final Network network;
    private final Integer crudVersion;

    public final void async(@NotNull String id, @NotNull NoObjectCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String queryParameters = this.getQueryParameters();
        String partialPath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection + '/' + id : this.collection + '/' + id;
        CharSequence charSequence = queryParameters;
        String relativePath = charSequence.length() == 0 ? partialPath : partialPath + '?' + queryParameters;
        this.network.getQueryRestInterface().deleteId(relativePath).enqueue((Callback)new Callback<ResponseBody>(callback){
            final /* synthetic */ NoObjectCallback $callback;

            public void onResponse(@Nullable Call<ResponseBody> call, @NotNull Response<ResponseBody> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                CRUDError error = null;
                if (!response.isSuccessful()) {
                    error = new CRUDError("Error code " + response.code());
                }
                this.$callback.onCompleted(error);
            }

            public void onFailure(@Nullable Call<ResponseBody> call, @Nullable Throwable t) {
                Throwable throwable = t;
                this.$callback.onCompleted(new CRUDError(throwable != null ? throwable.getMessage() : null));
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void async(@NotNull SingleObjectCallback<Integer> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        String queryParameters = this.getQueryParameters();
        String partialPath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection + '/' : this.collection + '/';
        String relativePath = partialPath + '?' + queryParameters;
        this.network.getQueryRestInterface().delete(relativePath).enqueue((Callback)new Callback<JsonElement>(callback){
            final /* synthetic */ SingleObjectCallback $callback;

            public void onResponse(@Nullable Call<JsonElement> call, @NotNull Response<JsonElement> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                CRUDError error = null;
                Integer result = null;
                if (response.isSuccessful() && response.body() != null) {
                    try {
                        Object object = response.body();
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        result = ((JsonElement)object).getAsInt();
                    }
                    catch (Exception e) {
                        error = new CRUDError(e.getMessage());
                    }
                } else {
                    error = new CRUDError("Error code " + response.code());
                }
                this.$callback.onCompleted(result, error);
            }

            public void onFailure(@Nullable Call<JsonElement> call, @Nullable Throwable t) {
                Throwable throwable = t;
                this.$callback.onCompleted(null, new CRUDError(throwable != null ? throwable.getMessage() : null));
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void sync(@NotNull String id) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        String queryParameters = this.getQueryParameters();
        String partialPath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection + '/' + id : this.collection + '/' + id;
        CharSequence charSequence = queryParameters;
        String relativePath = charSequence.length() == 0 ? partialPath : partialPath + '?' + queryParameters;
        Response response2 = response = this.network.getQueryRestInterface().deleteId(relativePath).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (!response2.isSuccessful()) {
            throw (Throwable)new CRUDError("Error code " + response.code());
        }
    }

    @Nullable
    public final Integer sync() {
        Response response;
        String queryParameters = this.getQueryParameters();
        String partialPath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection + '/' : this.collection + '/';
        String relativePath = partialPath + '?' + queryParameters;
        Response response2 = response = this.network.getQueryRestInterface().delete(relativePath).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (response2.isSuccessful()) {
            try {
                Object object = response.body();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                return ((JsonElement)object).getAsInt();
            }
            catch (Exception e) {
                throw (Throwable)e;
            }
        }
        throw (Throwable)new CRUDError("Error code " + response.code());
    }

    public final void state(@NotNull State state2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state2), (String)"state");
        this.state = state2.getValue();
    }

    public final void state(@NotNull ArrayList<State> state2) {
        Intrinsics.checkParameterIsNotNull(state2, (String)"state");
        this.state = CollectionsKt.joinToString$default((Iterable)state2, (CharSequence)",", null, null, (int)0, null, (Function1)state.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getQueryParameters() {
        void $receiver$iv$iv;
        String string;
        Object object;
        Map map;
        HashMap queryParameters = new HashMap();
        if (this.query != null) {
            map = queryParameters;
            object = Parameters.QUERY.getValue();
            String string2 = this.query;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = string2;
            map.put(object, string);
        }
        if (this.state != null) {
            map = queryParameters;
            object = Parameters.STATE.getValue();
            String string3 = this.state;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            string = string3;
            map.put(object, string);
        }
        Map $receiver$iv = queryParameters;
        object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var5_5 = $receiver$iv$iv;
        Iterator iterator = var5_5.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            String string4 = (String)it.getKey() + '=' + it.getValue();
            collection.add(string4);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    public DELETE(@NotNull String collection, @NotNull Network network, @Nullable Integer crudVersion) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        this.collection = collection;
        this.network = network;
        this.crudVersion = crudVersion;
    }

    public /* synthetic */ DELETE(String string, Network network, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        this(string, network, n);
    }

    public DELETE(@NotNull String collection, @NotNull String query, @NotNull Network network, @Nullable Integer crudVersion) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        this(collection, network, crudVersion);
        this.query = query;
    }

    public /* synthetic */ DELETE(String string, String string2, Network network, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        this(string, string2, network, n);
    }

    public DELETE(@NotNull String collection, @NotNull QueryBuilder queryBuilder, @NotNull Network network, @Nullable Integer crudVersion) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        this(collection, network, crudVersion);
        this.query = queryBuilder.build();
    }

    public /* synthetic */ DELETE(String string, QueryBuilder queryBuilder, Network network, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        this(string, queryBuilder, network, n);
    }
}

