/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.crud.library;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.miaplatform.crud.library.GsonFactory;
import eu.miaplatform.crud.library.enums.MongoOperator;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\t\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u000b\"\u00020\u0000\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ+\u0010\u000f\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u0002H\u00102\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0019\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0017J1\u0010\u001a\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00100\u000b\"\u0002H\u0010\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0017J%\u0010\u001e\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0017J%\u0010\u001f\u001a\u00020\u00002\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u000b2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u000b\"\u00020\u0000\u00a2\u0006\u0002\u0010\fJ-\u0010\"\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010%J%\u0010&\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0017J1\u0010'\u001a\u00020\u0000\"\b\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00100\u000b\"\u0002H\u0010\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010(\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u000b\"\u00020\u0000\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"Leu/miaplatform/crud/library/QueryBuilder;", "", "()V", "query", "Lcom/google/gson/JsonObject;", "getQuery", "()Lcom/google/gson/JsonObject;", "setQuery", "(Lcom/google/gson/JsonObject;)V", "and", "queryBuilders", "", "([Leu/miaplatform/crud/library/QueryBuilder;)Leu/miaplatform/crud/library/QueryBuilder;", "build", "", "comparisonQuery", "T", "key", "value", "mongoOperator", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)Leu/miaplatform/crud/library/QueryBuilder;", "equals", "Ljava/io/Serializable;", "(Ljava/lang/String;Ljava/io/Serializable;)Leu/miaplatform/crud/library/QueryBuilder;", "greater", "greaterOrEquals", "inArray", "values", "(Ljava/lang/String;[Ljava/io/Serializable;)Leu/miaplatform/crud/library/QueryBuilder;", "less", "lessOrEquals", "logicalQuery", "([Leu/miaplatform/crud/library/QueryBuilder;Ljava/lang/String;)Leu/miaplatform/crud/library/QueryBuilder;", "nor", "not", "comparisonOperator", "Leu/miaplatform/crud/library/enums/MongoOperator;", "(Ljava/lang/String;Leu/miaplatform/crud/library/enums/MongoOperator;Ljava/io/Serializable;)Leu/miaplatform/crud/library/QueryBuilder;", "notEquals", "notInArray", "or", "custom-plugin-java"})
public final class QueryBuilder {
    @NotNull
    private JsonObject query = new JsonObject();

    @NotNull
    public final JsonObject getQuery() {
        return this.query;
    }

    public final void setQuery(@NotNull JsonObject jsonObject) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"<set-?>");
        this.query = jsonObject;
    }

    @NotNull
    public final String build() {
        String string = this.query.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"query.toString()");
        return string;
    }

    @NotNull
    public final QueryBuilder and(QueryBuilder ... queryBuilders) {
        Intrinsics.checkParameterIsNotNull((Object)queryBuilders, (String)"queryBuilders");
        return this.logicalQuery(queryBuilders, MongoOperator.AND.getValue());
    }

    @NotNull
    public final QueryBuilder or(QueryBuilder ... queryBuilders) {
        Intrinsics.checkParameterIsNotNull((Object)queryBuilders, (String)"queryBuilders");
        return this.logicalQuery(queryBuilders, MongoOperator.OR.getValue());
    }

    @NotNull
    public final QueryBuilder nor(QueryBuilder ... queryBuilders) {
        Intrinsics.checkParameterIsNotNull((Object)queryBuilders, (String)"queryBuilders");
        return this.logicalQuery(queryBuilders, MongoOperator.NOR.getValue());
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder not(@NotNull String key, @NotNull MongoOperator comparisonOperator, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)((Object)comparisonOperator), (String)"comparisonOperator");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        JsonObject obj = new JsonObject();
        obj.add(comparisonOperator.getValue(), GsonFactory.Companion.newGsonInstance().toJsonTree(value));
        JsonObject notQuery = new JsonObject();
        notQuery.add(MongoOperator.NOT.getValue(), (JsonElement)obj);
        this.query.add(key, (JsonElement)notQuery);
        return this;
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder equals(@NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.query.add(key, GsonFactory.Companion.newGsonInstance().toJsonTree(value));
        return this;
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder notEquals(@NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.comparisonQuery(key, value, MongoOperator.NOT_EQUALS.getValue());
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder greater(@NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.comparisonQuery(key, value, MongoOperator.GREATER_THAN.getValue());
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder greaterOrEquals(@NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.comparisonQuery(key, value, MongoOperator.GREATER_THAN_EQUALS.getValue());
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder less(@NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.comparisonQuery(key, value, MongoOperator.LESS_THAN.getValue());
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder lessOrEquals(@NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.comparisonQuery(key, value, MongoOperator.LESS_THAN_EQUALS.getValue());
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder inArray(@NotNull String key, T ... values) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        JsonArray valuesArray = new JsonArray();
        for (T value : values) {
            valuesArray.add(GsonFactory.Companion.newGsonInstance().toJsonTree(value));
        }
        JsonObject inJsonObject = new JsonObject();
        inJsonObject.add(MongoOperator.IN.getValue(), (JsonElement)valuesArray);
        this.query.add(key, (JsonElement)inJsonObject);
        return this;
    }

    @NotNull
    public final <T extends Serializable> QueryBuilder notInArray(@NotNull String key, T ... values) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        JsonArray valuesArray = new JsonArray();
        for (T value : values) {
            valuesArray.add(GsonFactory.Companion.newGsonInstance().toJsonTree(value));
        }
        JsonObject inJsonObject = new JsonObject();
        inJsonObject.add(MongoOperator.NOT_IN.getValue(), (JsonElement)valuesArray);
        this.query.add(key, (JsonElement)inJsonObject);
        return this;
    }

    private final <T> QueryBuilder comparisonQuery(String key, T value, String mongoOperator) {
        JsonObject obj = new JsonObject();
        obj.add(mongoOperator, GsonFactory.Companion.newGsonInstance().toJsonTree(value));
        this.query.add(key, (JsonElement)obj);
        return this;
    }

    private final QueryBuilder logicalQuery(QueryBuilder[] queryBuilders, String mongoOperator) {
        JsonArray array = new JsonArray();
        for (QueryBuilder builder : queryBuilders) {
            array.add((JsonElement)builder.query);
        }
        this.query.add(mongoOperator, (JsonElement)array);
        return this;
    }
}

