/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.crud.library;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.miaplatform.crud.library.CRUDError;
import eu.miaplatform.crud.library.CRUDObject;
import eu.miaplatform.crud.library.GsonFactory;
import eu.miaplatform.crud.library.Network;
import eu.miaplatform.crud.library.enums.State;
import eu.miaplatform.crud.library.listeners.MultipleObjectsCallback;
import eu.miaplatform.crud.library.listeners.NoObjectCallback;
import eu.miaplatform.crud.library.listeners.SingleObjectCallback;
import eu.miaplatform.crud.library.restInterfaces.DefaultRestInterface;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ5\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016\u00a2\u0006\u0002\u0010\u0017J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016J6\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00100\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aJ\u001e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0003H\u0002J)\u0010%\u001a\u0004\u0018\u00010\u0003\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010&J \u0010%\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J0\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001e\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00100\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Leu/miaplatform/crud/library/POST;", "", "collection", "", "network", "Leu/miaplatform/crud/library/Network;", "crudVersion", "", "(Ljava/lang/String;Leu/miaplatform/crud/library/Network;Ljava/lang/Integer;)V", "getCollection", "()Ljava/lang/String;", "setCollection", "(Ljava/lang/String;)V", "Ljava/lang/Integer;", "async", "", "T", "Ljava/io/Serializable;", "obj", "state", "Leu/miaplatform/crud/library/enums/State;", "callback", "Leu/miaplatform/crud/library/listeners/SingleObjectCallback;", "(Ljava/io/Serializable;Leu/miaplatform/crud/library/enums/State;Leu/miaplatform/crud/library/listeners/SingleObjectCallback;)V", "jsonArray", "Lcom/google/gson/JsonArray;", "Leu/miaplatform/crud/library/listeners/MultipleObjectsCallback;", "jsonObject", "Lcom/google/gson/JsonObject;", "objs", "Ljava/util/ArrayList;", "asyncChangeState", "id", "Leu/miaplatform/crud/library/listeners/NoObjectCallback;", "createRawBodyFromJson", "Lokhttp3/RequestBody;", "json", "sync", "(Ljava/io/Serializable;Leu/miaplatform/crud/library/enums/State;)Ljava/lang/String;", "syncChangeState", "Leu/miaplatform/crud/library/CRUDError;", "custom-plugin-java"})
public final class POST {
    @NotNull
    private String collection;
    private final Network network;
    private final Integer crudVersion;

    public final <T extends Serializable> void async(@NotNull T obj, @Nullable State state2, @NotNull SingleObjectCallback<String> callback) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            JsonObject jsonObject;
            JsonElement jsonElement = GsonFactory.Companion.newGsonInstance().toJsonTree(obj);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"GsonFactory.newGsonInstance().toJsonTree(obj)");
            JsonObject jsonObject2 = jsonObject = jsonElement.getAsJsonObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject2, (String)"jsonObject");
            this.async(jsonObject2, state2, callback);
        }
        catch (Exception e) {
            callback.onCompleted(null, new CRUDError(e.getMessage()));
        }
    }

    public final <T extends Serializable> void async(@NotNull ArrayList<T> objs, @Nullable State state2, @NotNull MultipleObjectsCallback<String> callback) {
        Intrinsics.checkParameterIsNotNull(objs, (String)"objs");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            JsonArray array = new JsonArray();
            for (Serializable obj : objs) {
                JsonElement jsonElement = GsonFactory.Companion.newGsonInstance().toJsonTree((Object)obj);
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"GsonFactory.newGsonInstance().toJsonTree(obj)");
                JsonObject element = jsonElement.getAsJsonObject();
                array.add((JsonElement)element);
            }
            this.async(array, state2, callback);
        }
        catch (Exception e) {
            callback.onCompleted(null, new CRUDError(e.getMessage()));
        }
    }

    public final void async(@NotNull JsonObject jsonObject, @Nullable State state2, @NotNull SingleObjectCallback<String> callback) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        String relativePath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection : this.collection;
        Gson gson = GsonFactory.Companion.newGsonInstance();
        if (state2 != null) {
            jsonObject.addProperty(CRUDObject.INSTANCE.getSTATE_KEY$custom_plugin_java(), state2.getValue());
        } else {
            jsonObject.addProperty(CRUDObject.INSTANCE.getSTATE_KEY$custom_plugin_java(), State.Pub.getValue());
        }
        String jsonString = gson.toJson((JsonElement)jsonObject);
        DefaultRestInterface defaultRestInterface = this.network.getQueryRestInterface();
        String string = jsonString;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonString");
        RequestBody requestBody = this.createRawBodyFromJson(string);
        if (requestBody == null) {
            Intrinsics.throwNpe();
        }
        defaultRestInterface.post(relativePath, requestBody).enqueue((Callback)new Callback<JsonObject>(callback){
            final /* synthetic */ SingleObjectCallback $callback;

            public void onResponse(@Nullable Call<JsonObject> call, @NotNull Response<JsonObject> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                CRUDError error = null;
                String result = null;
                if (response.isSuccessful() && response.body() != null) {
                    try {
                        Object object = response.body();
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"response.body()!!");
                        JsonObject obj = ((JsonObject)object).getAsJsonObject();
                        JsonElement jsonElement = obj.get("_id");
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj.get(\"_id\")");
                        result = jsonElement.getAsString();
                    }
                    catch (Exception e) {
                        this.$callback.onCompleted(null, new CRUDError(e.getMessage()));
                    }
                } else {
                    error = new CRUDError("Error code " + response.code());
                }
                this.$callback.onCompleted(result, error);
            }

            public void onFailure(@Nullable Call<JsonObject> call, @Nullable Throwable t) {
                Throwable throwable = t;
                this.$callback.onCompleted(null, new CRUDError(throwable != null ? throwable.getMessage() : null));
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void async(@NotNull JsonArray jsonArray, @Nullable State state2, @NotNull MultipleObjectsCallback<String> callback) {
        JsonElement element;
        Gson gson;
        String relativePath;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)jsonArray, (String)"jsonArray");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            relativePath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection : this.collection;
            gson = GsonFactory.Companion.newGsonInstance();
            if (state2 == null) break block6;
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JsonElement jsonElement = element = (JsonElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"element");
                jsonElement.getAsJsonObject().addProperty(CRUDObject.INSTANCE.getSTATE_KEY$custom_plugin_java(), state2.getValue());
            }
        }
        try {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JsonElement jsonElement = element = (JsonElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"element");
                jsonElement.getAsJsonObject().addProperty(CRUDObject.INSTANCE.getSTATE_KEY$custom_plugin_java(), State.Pub.getValue());
            }
        }
        catch (Exception e) {
            callback.onCompleted(null, new CRUDError(e.getMessage()));
        }
        String jsonString = gson.toJson((JsonElement)jsonArray);
        DefaultRestInterface defaultRestInterface = this.network.getQueryRestInterface();
        String string = jsonString;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonString");
        RequestBody requestBody = this.createRawBodyFromJson(string);
        if (requestBody == null) {
            Intrinsics.throwNpe();
        }
        defaultRestInterface.bulkPost(relativePath, requestBody).enqueue((Callback)new Callback<JsonArray>(callback){
            final /* synthetic */ MultipleObjectsCallback $callback;

            public void onResponse(@Nullable Call<JsonArray> call, @NotNull Response<JsonArray> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                CRUDError error = null;
                ArrayList<String> result = null;
                if (response.isSuccessful() && response.body() != null) {
                    try {
                        result = new ArrayList<String>();
                        Object object = response.body();
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"response.body()!!");
                        JsonArray objs = ((JsonArray)object).getAsJsonArray();
                        Iterator iterator = objs.iterator();
                        while (iterator.hasNext()) {
                            JsonElement obj;
                            JsonElement jsonElement = obj = (JsonElement)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj");
                            JsonObject jsonObject = jsonElement.getAsJsonObject();
                            JsonElement jsonElement2 = jsonObject.get("_id");
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"jsonObject.get(\"_id\")");
                            result.add(jsonElement2.getAsString());
                        }
                    }
                    catch (Exception e) {
                        this.$callback.onCompleted(null, new CRUDError(e.getMessage()));
                    }
                } else {
                    error = new CRUDError("Error code " + response.code());
                }
                this.$callback.onCompleted(result, error);
            }

            public void onFailure(@Nullable Call<JsonArray> call, @Nullable Throwable t) {
                Throwable throwable = t;
                this.$callback.onCompleted(null, new CRUDError(throwable != null ? throwable.getMessage() : null));
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @Nullable
    public final <T extends Serializable> String sync(@NotNull T obj, @Nullable State state2) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        try {
            JsonObject jsonObject;
            JsonElement jsonElement = GsonFactory.Companion.newGsonInstance().toJsonTree(obj);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"GsonFactory.newGsonInstance().toJsonTree(obj)");
            JsonObject jsonObject2 = jsonObject = jsonElement.getAsJsonObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject2, (String)"jsonObject");
            return this.sync(jsonObject2, state2);
        }
        catch (Exception e) {
            throw (Throwable)e;
        }
    }

    @Nullable
    public final String sync(@NotNull JsonObject jsonObject, @Nullable State state2) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        String relativePath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection : this.collection;
        try {
            Response response;
            Gson gson = GsonFactory.Companion.newGsonInstance();
            if (state2 != null) {
                jsonObject.addProperty(CRUDObject.INSTANCE.getSTATE_KEY$custom_plugin_java(), state2.getValue());
            } else {
                jsonObject.addProperty(CRUDObject.INSTANCE.getSTATE_KEY$custom_plugin_java(), State.Pub.getValue());
            }
            String jsonString = gson.toJson((JsonElement)jsonObject);
            DefaultRestInterface defaultRestInterface = this.network.getQueryRestInterface();
            String string = jsonString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonString");
            RequestBody requestBody = this.createRawBodyFromJson(string);
            if (requestBody == null) {
                Intrinsics.throwNpe();
            }
            Response response2 = response = defaultRestInterface.post(relativePath, requestBody).execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            if (response2.isSuccessful()) {
                JsonObject obj = (JsonObject)response.body();
                JsonObject jsonObject2 = obj;
                return jsonObject2 != null && (jsonObject2 = jsonObject2.get("_id")) != null ? jsonObject2.getAsString() : null;
            }
            throw (Throwable)new CRUDError("Error code " + response.code());
        }
        catch (Exception e) {
            throw (Throwable)e;
        }
    }

    @Nullable
    public final <T extends Serializable> ArrayList<String> sync(@NotNull ArrayList<T> objs, @Nullable State state2) {
        Intrinsics.checkParameterIsNotNull(objs, (String)"objs");
        JsonArray array = new JsonArray();
        try {
            for (Serializable obj : objs) {
                JsonElement jsonElement = GsonFactory.Companion.newGsonInstance().toJsonTree((Object)obj);
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"GsonFactory.newGsonInstance().toJsonTree(obj)");
                JsonObject element = jsonElement.getAsJsonObject();
                array.add((JsonElement)element);
            }
            return this.sync(array, state2);
        }
        catch (Exception e) {
            throw (Throwable)e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final ArrayList<String> sync(@NotNull JsonArray jsonArray, @Nullable State state2) {
        Intrinsics.checkParameterIsNotNull((Object)jsonArray, (String)"jsonArray");
        String relativePath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection : this.collection;
        try {
            Response response;
            JsonElement element;
            Iterator iterator;
            Gson gson = GsonFactory.Companion.newGsonInstance();
            if (state2 != null) {
                iterator = jsonArray.iterator();
                while (iterator.hasNext()) {
                    JsonElement jsonElement = element = (JsonElement)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"element");
                    jsonElement.getAsJsonObject().addProperty(CRUDObject.INSTANCE.getSTATE_KEY$custom_plugin_java(), state2.getValue());
                }
            } else {
                iterator = jsonArray.iterator();
                while (iterator.hasNext()) {
                    JsonElement jsonElement = element = (JsonElement)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"element");
                    jsonElement.getAsJsonObject().addProperty(CRUDObject.INSTANCE.getSTATE_KEY$custom_plugin_java(), State.Pub.getValue());
                }
            }
            String jsonString = gson.toJson((JsonElement)jsonArray);
            DefaultRestInterface defaultRestInterface = this.network.getQueryRestInterface();
            String string = jsonString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonString");
            RequestBody requestBody = this.createRawBodyFromJson(string);
            if (requestBody == null) {
                Intrinsics.throwNpe();
            }
            Response response2 = response = defaultRestInterface.bulkPost(relativePath, requestBody).execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            if (!response2.isSuccessful()) {
                throw (Throwable)new CRUDError("Error code " + response.code());
            }
            JsonArray objs = (JsonArray)response.body();
            ArrayList<String> ids = null;
            if (objs != null) {
                ids = new ArrayList<String>();
                Iterator iterator2 = objs.iterator();
                while (iterator2.hasNext()) {
                    String id;
                    JsonElement obj;
                    JsonElement jsonElement = obj = (JsonElement)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj");
                    JsonElement jsonElement2 = jsonElement.getAsJsonObject().get("_id");
                    String string2 = id = jsonElement2 != null ? jsonElement2.getAsString() : null;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ids.add(string2);
                }
            }
            return ids;
        }
        catch (Exception e) {
            throw (Throwable)e;
        }
    }

    public final void asyncChangeState(@NotNull String id, @NotNull State state2, @NotNull NoObjectCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)((Object)state2), (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String relativePath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection + '/' + id + "/state" : this.collection + '/' + id + "/state";
        Gson gson = GsonFactory.Companion.newGsonInstance();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("stateTo", state2.getValue());
        String jsonString = gson.toJson((JsonElement)jsonObject);
        DefaultRestInterface defaultRestInterface = this.network.getQueryRestInterface();
        String string = jsonString;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonString");
        RequestBody requestBody = this.createRawBodyFromJson(string);
        if (requestBody == null) {
            Intrinsics.throwNpe();
        }
        defaultRestInterface.statePost(relativePath, requestBody).enqueue((Callback)new Callback<ResponseBody>(callback){
            final /* synthetic */ NoObjectCallback $callback;

            public void onResponse(@Nullable Call<ResponseBody> call, @NotNull Response<ResponseBody> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                CRUDError error = null;
                if (!response.isSuccessful()) {
                    error = new CRUDError("Error code " + response.code());
                }
                this.$callback.onCompleted(error);
            }

            public void onFailure(@Nullable Call<ResponseBody> call, @Nullable Throwable t) {
                Throwable throwable = t;
                this.$callback.onCompleted(new CRUDError(throwable != null ? throwable.getMessage() : null));
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @Nullable
    public final CRUDError syncChangeState(@NotNull String id, @NotNull State state2) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)((Object)state2), (String)"state");
        String relativePath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection + '/' + id + "/state" : this.collection + '/' + id + "/state";
        Gson gson = GsonFactory.Companion.newGsonInstance();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("stateTo", state2.getValue());
        String jsonString = gson.toJson((JsonElement)jsonObject);
        DefaultRestInterface defaultRestInterface = this.network.getQueryRestInterface();
        String string = jsonString;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonString");
        RequestBody requestBody = this.createRawBodyFromJson(string);
        if (requestBody == null) {
            Intrinsics.throwNpe();
        }
        Response response2 = response = defaultRestInterface.statePost(relativePath, requestBody).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2.isSuccessful() ? null : new CRUDError("Error code " + response.code());
    }

    private final RequestBody createRawBodyFromJson(String json) {
        try {
            Object object;
            String string = json;
            Object object2 = "UTF-8";
            MediaType mediaType = MediaType.parse((String)"application/json");
            Charset charset = Charset.forName((String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
            object2 = object = charset;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes((Charset)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray;
            return RequestBody.create((MediaType)mediaType, (byte[])object);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public final String getCollection() {
        return this.collection;
    }

    public final void setCollection(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.collection = string;
    }

    public POST(@NotNull String collection, @NotNull Network network, @Nullable Integer crudVersion) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        this.collection = collection;
        this.network = network;
        this.crudVersion = crudVersion;
    }

    public /* synthetic */ POST(String string, Network network, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        this(string, network, n);
    }
}

