/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Download;
import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.system.Debian;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Apt {
    public static void install(String ... packageNames) {
        Apt.install(Arrays.asList(packageNames));
    }

    public static void install(List<String> packageNames) {
        try (Step step = Step.start("Install %s".formatted(String.join((CharSequence)", ", packageNames)));){
            List<String> uninstalled = packageNames.stream().filter(Predicate.not(Apt::isInstalled)).toList();
            if (uninstalled.isEmpty()) {
                step.skip("Already installed");
                return;
            }
            Apt.update();
            Shell.sudo(Stream.concat(Stream.of("apt-get", "install", "-y"), uninstalled.stream()).toList());
        }
    }

    public static void installFromUrl(URI uri) {
        try (Step step = Step.start("Install deb from %s".formatted(uri));){
            Path debPath = Download.intoTempFile(uri);
            Apt.install(debPath.toString());
        }
    }

    public static void purge(String ... packageNames) {
        try (Step step = Step.start("Purge %s".formatted(String.join((CharSequence)", ", packageNames)));){
            Shell.sudo(Stream.concat(Stream.of("apt-get", "purge", "-y"), Arrays.stream(packageNames)).toList());
        }
    }

    public static void update() {
        try (Step step = Step.start("Update package lists");){
            Shell.sudo("apt-get", "update");
        }
    }

    public static boolean isInstalled(String packageName) {
        Shell.Result result = Shell.Command.user("dpkg-query", "--show", "--showformat=${db:Status-Status}", packageName).failOnError(false).run();
        return result.success() && "installed".equals(result.stdout());
    }

    private static Path addPublicKey(String keyringName, URI url) {
        Apt.install("gpg");
        byte[] pubKeyBytes = Download.contentBytes(url);
        byte[] dearmoredPubkey = Shell.Command.user("gpg", "--dearmor").stdin(new ByteArrayInputStream(pubKeyBytes)).binaryStdout(true).run().binaryStdout();
        Path keyringFile = Path.of("/etc/apt/keyrings", keyringName);
        FileUtils.sudoWrite(keyringFile.toString(), dearmoredPubkey, "root:root", "644");
        return keyringFile;
    }

    public static String getArchitecture() {
        return Shell.user("dpkg", "--print-architecture").trim();
    }

    public static void addSource(Source source) {
        try (Step step = Step.start("APT: add source %s".formatted(source.identifier()));){
            Path keyringFile = null;
            if (source.keyringName() != null && source.publicKeyUri() != null) {
                keyringFile = Apt.addPublicKey(source.keyringName(), source.publicKeyUri());
            }
            StringBuilder builder = new StringBuilder();
            builder.append("### THIS FILE IS AUTOMATICALLY CONFIGURED ###\n");
            builder.append("Types: deb\n");
            builder.append("URIs: ").append(source.uri()).append("\n");
            builder.append("Suites: ").append(source.suites().stream().collect(Collectors.joining(" "))).append("\n");
            builder.append("Components: ").append(source.components().stream().collect(Collectors.joining(" "))).append("\n");
            builder.append("Architectures: ").append(Apt.getArchitecture()).append("\n");
            if (keyringFile != null) {
                builder.append("Signed-By: ").append(keyringFile).append("\n");
            }
            FileUtils.sudoWrite("/etc/apt/sources.list.d/%s.sources".formatted(source.identifier()), builder.toString(), "root:root", "644");
        }
    }

    public record Source(String identifier, URI uri, List<String> suites, List<String> components, String keyringName, URI publicKeyUri) {
        public static Builder builder(String identifier, URI uri, String component) {
            return Source.builder(identifier, uri, Debian.codename(), component);
        }

        public static Builder builder(String identifier, URI uri, String suite, String component) {
            return Source.builder(identifier, uri, List.of(suite), List.of(component));
        }

        public static Builder builder(String identifier, URI uri, List<String> suites, List<String> components) {
            return new Builder(identifier, uri, suites, components);
        }

        public static class Builder {
            private final String identifier;
            private final URI uri;
            private final List<String> suites;
            private final List<String> components;
            private String keyringName;
            private URI publicKeyUri;

            private Builder(String identifier, URI uri, List<String> suites, List<String> components) {
                this.identifier = identifier;
                this.uri = uri;
                this.suites = suites;
                this.components = components;
            }

            public Builder setSignedBy(String keyringName, URI publicKeyUri) {
                this.keyringName = keyringName;
                this.publicKeyUri = publicKeyUri;
                return this;
            }

            public Source build() {
                return new Source(this.identifier, this.uri, this.suites, this.components, this.keyringName, this.publicKeyUri);
            }
        }
    }
}

