/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Download;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.system.Architecture;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;

public class Eclipse {
    private static final String INSTALL_URL_TEMPLATE = "https://gemmei.ftp.acc.umu.se/mirror/eclipse.org/technology/epp/downloads/release/%1$s/R/eclipse-jee-%1$s-R-linux-gtk-%2$s.tar.gz";
    private static final Map<Architecture, String> ARCH_SUFFIXES = Map.of(Architecture.AMD64, "x86_64", Architecture.ARM64, "aarch64");
    private static final Path APPS_DIR = Shell.HOME.resolve("apps");
    private static final Path INSTALL_DIR = APPS_DIR.resolve("eclipse");

    public static void install(String version) throws IOException {
        try (Step step = Step.start("Eclipse %s: install".formatted(version));){
            if (Files.exists(INSTALL_DIR, new LinkOption[0])) {
                step.skip("Eclipse is already installed");
                return;
            }
            Files.createDirectories(APPS_DIR, new FileAttribute[0]);
            URI downloadUri = URI.create(INSTALL_URL_TEMPLATE.formatted(version, ARCH_SUFFIXES.get((Object)Architecture.validated())));
            Path downloadedTarGz = Download.intoTempFile(downloadUri);
            Shell.user("tar", "-xzf", downloadedTarGz.toString(), "-C", APPS_DIR.toString());
            try (Stream<Path> dirStream = Files.list(APPS_DIR);){
                Path extractedDir = dirStream.filter(p -> Files.isDirectory(p, new LinkOption[0]) && p.getFileName().toString().startsWith("eclipse")).findFirst().orElseThrow(() -> new RuntimeException("Extracted Eclipse folder not found"));
                Files.move(extractedDir, INSTALL_DIR, new CopyOption[0]);
            }
        }
    }
}

