/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Download;
import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;

public class Firefox {
    private static final Apt.Source APT_SOURCE = Apt.Source.builder("mozilla", URI.create("https://packages.mozilla.org/apt"), "mozilla", "main").setSignedBy("packages.mozilla.org.gpg", URI.create("https://packages.mozilla.org/apt/repo-signing-key.gpg")).build();
    public static final Extension EXTENSION_BITWARDEN = new Extension("{446900e4-71c2-419f-a6a7-df9c091e268b}", URI.create("https://addons.mozilla.org/firefox/downloads/file/4562769/bitwarden_password_manager-2025.8.1.xpi"));
    public static final Extension EXTENSION_MULTI_ACCOUNT_CONTAINERS = new Extension("@testpilot-containers", URI.create("https://addons.mozilla.org/firefox/downloads/file/4355970/multi_account_containers-8.2.0.xpi"));
    public static final Extension EXTENSION_GRANTED_CONTAINERS = new Extension("{b5e0e8de-ebfe-4306-9528-bcc18241a490}", URI.create("https://addons.mozilla.org/firefox/downloads/file/4086622/granted-1.1.2.xpi"));
    public static final Extension EXTENSION_UBLOCK_ORIGIN = new Extension("uBlock0@raymondhill.net", URI.create("https://addons.mozilla.org/firefox/downloads/file/4531307/ublock_origin-1.65.0.xpi"));

    public static void installOfficial() {
        try (Step step = Step.start("Firefox: Install");){
            Apt.addSource(APT_SOURCE);
            Apt.update();
            Apt.install("firefox");
        }
    }

    public static void addDefaultExtensions(Path firefoxInstallDir, List<Extension> extensions) {
        try (Step step = Step.start("Firefox: install extensions");){
            Path externalExtensionsDir = firefoxInstallDir.resolve("distribution/extensions");
            Shell.sudo("mkdir", "-p", externalExtensionsDir.toString());
            for (Extension extension : extensions) {
                Path downloadPath = Download.intoTempFile(extension.downloadUrl);
                Path targetPath = externalExtensionsDir.resolve(extension.id + ".xpi");
                if (Files.exists(targetPath, new LinkOption[0])) continue;
                FileUtils.sudoCopy(downloadPath.toString(), targetPath.toString(), "root:root", "644");
            }
        }
    }

    public static void installBookmarks(Path bookmarksSourcePath) throws IOException {
        try (Step step = Step.start("Firefox: Install Bookmarks");){
            Path defaultProfileDir = Firefox.findProfileDir("default-release").orElse(null);
            if (defaultProfileDir == null) {
                Firefox.initDefaultProfile();
            }
            if ((defaultProfileDir = (Path)Firefox.findProfileDir("default-release").orElse(null)) == null) {
                step.fail("Failed creating / finding the default profile");
                return;
            }
            String sourceFileName = bookmarksSourcePath.getFileName().toString();
            String targetFileName = sourceFileName.toLowerCase().endsWith(".json") ? "bookmarks.json" : (sourceFileName.toLowerCase().endsWith(".html") ? "bookmarks.html" : "bookmarks.json");
            Path targetFile = defaultProfileDir.resolve(targetFileName);
            if (Files.exists(targetFile, new LinkOption[0])) {
                step.skip("Bookmarks already exist");
                return;
            }
            Path placesSqlite = defaultProfileDir.resolve("places.sqlite");
            if (Files.exists(placesSqlite, new LinkOption[0])) {
                Files.delete(placesSqlite);
            }
            Files.copy(bookmarksSourcePath, targetFile, new CopyOption[0]);
        }
    }

    private static Optional<Path> findProfileDir(String profileName) throws IOException {
        Path profilesDir = Shell.HOME.resolve(".mozilla/firefox");
        Files.createDirectories(profilesDir, new FileAttribute[0]);
        String suffix = "." + profileName;
        return Files.list(profilesDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(suffix)).findFirst();
    }

    private static void initDefaultProfile() {
        Shell.Command.user("firefox", "--headless", "--new-instance", "--no-remote").failOnError(false).runAsync();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Shell.user("killall", "firefox-bin");
    }

    public record Extension(String id, URI downloadUrl) {
    }
}

