/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.demo;

import fi.evolver.script.Dialog;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SequencedMap;

public class DialogDemo {
    public static void main(String[] args) {
        System.out.println("Dialog Demo Application");
        System.out.println("======================");
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.println("Choose a test:\n\n1. Simple form dialog\n2. Complex form with multiple field types\n3. Test readLine() from Input replacement\n4. Test readPassword() from Input replacement\n5. Test readMultilinePassword() from Input replacement\n6. Test Paragraph Dialog\n\n0. Exit");
            System.out.print("Enter choice: ");
            String choice = scanner.nextLine().strip();
            if (choice.equals("0")) break;
            try {
                switch (choice) {
                    case "1": {
                        DialogDemo.testSimpleForm();
                        break;
                    }
                    case "2": {
                        DialogDemo.testComplexForm();
                        break;
                    }
                    case "3": {
                        DialogDemo.testReadLine();
                        break;
                    }
                    case "4": {
                        DialogDemo.testReadPassword();
                        break;
                    }
                    case "5": {
                        DialogDemo.testReadMultilinePassword();
                        break;
                    }
                    case "6": {
                        DialogDemo.testLabels();
                        break;
                    }
                    default: {
                        System.out.println("Invalid choice");
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error during test: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        scanner.close();
        System.out.println("Demo ended.");
    }

    private static void testSimpleForm() {
        Dialog dialog = new Dialog("Simple Form Test");
        dialog.add(Dialog.textField("Name"));
        dialog.add(Dialog.textField("Email"));
        System.out.println("\nShowing simple form dialog...");
        SequencedMap<Dialog.DialogEntry, String> results = dialog.show();
        System.out.println("\nResults:");
        results.forEach((entry, value) -> System.out.println(entry.label() + ": " + value));
    }

    private static void testComplexForm() {
        Dialog dialog = new Dialog("Complex Form Test");
        dialog.add(Dialog.textField("Username"));
        dialog.add(Dialog.passwordField("Password"));
        dialog.add(Dialog.textArea("Bio"));
        dialog.add(Dialog.passwordArea("Secret Notes"));
        dialog.add(Dialog.checkBox("Subscribe to newsletter", true));
        List<String> accountTypes = List.of("Free", "Basic", "Premium", "Enterprise");
        dialog.add(Dialog.radioSelect("Account type", accountTypes, 1));
        System.out.println("\nShowing complex form dialog...");
        SequencedMap<Dialog.DialogEntry, String> results = dialog.show();
        System.out.println("\nResults:");
        block5: for (Map.Entry entry : results.entrySet()) {
            String name = ((Dialog.DialogEntry)entry.getKey()).label();
            String value = (String)entry.getValue();
            Dialog.DialogEntry dialogEntry = (Dialog.DialogEntry)entry.getKey();
            int n = 0;
            block6: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dialog.DialogTextField.class, Dialog.DialogCheckBox.class, Dialog.DialogRadioSelect.class}, (Object)dialogEntry, n)) {
                    case 0: {
                        Dialog.DialogTextField field = (Dialog.DialogTextField)dialogEntry;
                        if (!field.isPassword()) {
                            n = 1;
                            continue block6;
                        }
                        System.out.println(name + ": " + "*".repeat(value.length()));
                        continue block5;
                    }
                    case 1: {
                        Dialog.DialogCheckBox ignored = (Dialog.DialogCheckBox)dialogEntry;
                        System.out.println(name + ": " + (value.equals("true") ? "\u2713 Checked" : "\u25a1 Unchecked"));
                        continue block5;
                    }
                    case 2: {
                        Dialog.DialogRadioSelect ignored = (Dialog.DialogRadioSelect)dialogEntry;
                        System.out.println(name + ": Selected option: " + value);
                        continue block5;
                    }
                }
                break;
            }
            System.out.println(name + ": " + value);
        }
    }

    private static void testReadLine() {
        System.out.println("\nTesting readLine()...");
        String input = Dialog.readLine("Enter some text:");
        System.out.println("You entered: " + input);
    }

    private static void testReadPassword() {
        System.out.println("\nTesting readPassword()...");
        String password = Dialog.readPassword("Enter a password:");
        System.out.println("Password length: " + password.length());
        System.out.println("Password (masked): " + "*".repeat(password.length()));
    }

    private static void testReadMultilinePassword() {
        System.out.println("\nTesting readMultilinePassword()...");
        String multilinePassword = Dialog.readMultilinePassword("Enter a multiline password (like a SSH key):");
        System.out.println("Multiline password length: " + multilinePassword.length());
        System.out.println("Number of lines: " + multilinePassword.lines().count());
        System.out.println("First few characters (masked): " + "*".repeat(Math.min(multilinePassword.length(), 10)) + (multilinePassword.length() > 10 ? "..." : ""));
    }

    private static void testLabels() {
        Dialog dialog = new Dialog("Information Dialog");
        dialog.add(Dialog.paragraph("This is an informational message that doesn't require any input."));
        dialog.add(Dialog.paragraph("Important Information\n\nYou are arrested!"));
        dialog.add(Dialog.textField("Any comments?"));
        dialog.add(Dialog.paragraph("System Status: All systems are operational. No issues detected."));
        System.out.println("\nShowing paragraph dialog...");
        SequencedMap<Dialog.DialogEntry, String> results = dialog.show();
        System.out.println("\nResults:");
        String comment = results.values().stream().filter(s -> !s.isEmpty()).findFirst().orElse("No comments provided.");
        System.out.println("Comment: " + comment);
    }
}

