/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.io;

import java.io.OutputStream;
import java.util.Arrays;

public class ByteArrayBuilder
extends OutputStream {
    private static final int INITIAL_CAP = 8;
    private byte[] buf = new byte[8];
    private int size;

    private void ensureCap(int req) {
        if (req > this.buf.length) {
            int newCap = this.buf.length * 2;
            if (newCap < req) {
                newCap = req;
            }
            this.buf = Arrays.copyOf(this.buf, newCap);
        }
    }

    @Override
    public void write(int b) {
        this.ensureCap(this.size + 1);
        this.buf[this.size++] = (byte)b;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureCap(this.size + len);
        System.arraycopy(b, off, this.buf, this.size, len);
        this.size += len;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public byte[] array() {
        return this.buf;
    }

    public int size() {
        return this.size;
    }
}

