/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.io;

import foundation.icon.ee.io.ByteArrayBuilder;
import foundation.icon.ee.io.DataWriter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;

public class RLPDataWriter
implements DataWriter {
    private static final int SHORT_BASE = 128;
    private static final int SHORT_LEN_LIMIT = 55;
    private static final int LONG_BASE = 183;
    private ArrayList<ByteArrayBuilder> frames = new ArrayList();
    private ByteArrayBuilder os = new ByteArrayBuilder();

    public RLPDataWriter() {
        this.frames.add(this.os);
    }

    private void writeRLPString(byte[] bs) {
        int l = bs.length;
        if (l == 1 && (bs[0] & 0xFF) < 128) {
            this.os.write(bs[0]);
        } else if (l <= 55) {
            this.os.write(128 + l);
            this.os.write(bs, 0, l);
        } else if (l <= 255) {
            this.os.write(184);
            this.os.write(l);
            this.os.write(bs, 0, l);
        } else if (l <= 65535) {
            this.os.write(185);
            this.os.write(l >> 8);
            this.os.write(l);
            this.os.write(bs, 0, l);
        } else if (l <= 0xFFFFFF) {
            this.os.write(186);
            this.os.write(l >> 16);
            this.os.write(l >> 8);
            this.os.write(l);
            this.os.write(bs, 0, l);
        } else {
            this.os.write(187);
            this.os.write(l >> 24);
            this.os.write(l >> 16);
            this.os.write(l >> 8);
            this.os.write(l);
            this.os.write(bs, 0, l);
        }
    }

    @Override
    public void write(boolean v) {
        this.writeRLPString(BigInteger.valueOf(v ? 1L : 0L).toByteArray());
    }

    @Override
    public void write(byte v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(short v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(char v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(int v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(float v) {
        int i = Float.floatToRawIntBits(v);
        this.os.write(132);
        this.os.write(i >> 24 & 0xFF);
        this.os.write(i >> 16 & 0xFF);
        this.os.write(i >> 8 & 0xFF);
        this.os.write(i & 0xFF);
    }

    @Override
    public void write(long v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(double v) {
        long i = Double.doubleToRawLongBits(v);
        this.os.write(136);
        this.os.write((int)(i >> 54) & 0xFF);
        this.os.write((int)(i >> 48) & 0xFF);
        this.os.write((int)(i >> 40) & 0xFF);
        this.os.write((int)(i >> 32) & 0xFF);
        this.os.write((int)(i >> 24) & 0xFF);
        this.os.write((int)(i >> 16) & 0xFF);
        this.os.write((int)(i >> 8) & 0xFF);
        this.os.write((int)i & 0xFF);
    }

    @Override
    public void write(BigInteger v) {
        this.writeRLPString(v.toByteArray());
    }

    @Override
    public void write(String v) {
        this.writeRLPString(v.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void write(byte[] v) {
        this.writeRLPString(v);
    }

    @Override
    public void writeNullity(boolean nullity) {
        if (nullity) {
            this.writeNull();
        }
    }

    @Override
    public void writeListHeader(int l) {
        this._writeRLPListHeader();
    }

    @Override
    public void writeMapHeader(int l) {
        this._writeRLPListHeader();
    }

    private void _writeRLPListHeader() {
        this.os = new ByteArrayBuilder();
        this.frames.add(this.os);
    }

    private void _writeRLPListFooter() {
        ByteArrayBuilder prev = this.os;
        int l = prev.size();
        this.frames.remove(this.frames.size() - 1);
        this.os = this.frames.get(this.frames.size() - 1);
        if (l <= 55) {
            this.os.write(192 + l);
            this.os.write(prev.array(), 0, prev.size());
        } else if (l <= 255) {
            this.os.write(248);
            this.os.write(l);
            this.os.write(prev.array(), 0, prev.size());
        } else if (l <= 65535) {
            this.os.write(249);
            this.os.write(l >> 8 & 0xFF);
            this.os.write(l & 0xFF);
            this.os.write(prev.array(), 0, prev.size());
        } else if (l <= 0xFFFFFF) {
            this.os.write(250);
            this.os.write(l >> 16 & 0xFF);
            this.os.write(l >> 8 & 0xFF);
            this.os.write(l & 0xFF);
            this.os.write(prev.array(), 0, prev.size());
        } else {
            this.os.write(251);
            this.os.write(l >> 24 & 0xFF);
            this.os.write(l >> 16 & 0xFF);
            this.os.write(l >> 8 & 0xFF);
            this.os.write(l & 0xFF);
            this.os.write(prev.array(), 0, prev.size());
        }
    }

    @Override
    public void writeFooter() {
        this._writeRLPListFooter();
    }

    private void writeNull() {
        this.os.write(248);
        this.os.write(0);
    }

    @Override
    public void flush() {
        this.os.flush();
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.os.array(), 0, this.os.size());
    }

    @Override
    public long getTotalWrittenBytes() {
        return this.os.size();
    }
}

