/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.score;

import foundation.icon.ee.score.Transformer;
import foundation.icon.ee.util.MultimapCache;
import i.RuntimeAssertionError;
import java.io.IOException;
import org.aion.avm.core.AvmConfiguration;
import org.aion.avm.core.DAppLoader;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.persistence.LoadedDApp;

public class Loader {
    private static final int CAP = 256;
    private final MultimapCache<String, LoadedDApp> cache = MultimapCache.newSoftCache(256);

    public LoadedDApp load(IExternalState es, AvmConfiguration conf) {
        LoadedDApp dapp = this.cache.remove(es.getCodeID(), da -> da.hasSameGraphHash(es.getObjectGraphHash()));
        if (dapp == null) {
            byte[] code;
            try {
                code = es.getTransformedCode();
            }
            catch (IOException e) {
                Transformer transformer = new Transformer(es, conf);
                transformer.transform();
                code = transformer.getTransformedCodeBytes();
                es.setTransformedCode(code);
            }
            try {
                dapp = DAppLoader.loadFromGraph(code, conf.preserveDebuggability);
            }
            catch (IOException e) {
                RuntimeAssertionError.unexpected(e);
            }
        }
        return dapp;
    }

    public void unload(String codeID, LoadedDApp dapp) {
        this.cache.put(codeID, dapp);
    }
}

