/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.score;

import foundation.icon.ee.score.ValidationException;
import foundation.icon.ee.struct.Member;
import foundation.icon.ee.struct.MemberDecl;
import foundation.icon.ee.struct.MethodCollector;
import foundation.icon.ee.struct.StructDB;
import foundation.icon.ee.types.Method;
import foundation.icon.ee.util.ASM;
import foundation.icon.ee.util.MethodUnpacker;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.aion.avm.core.dappreading.LoadedJar;
import org.aion.avm.utilities.JarBuilder;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.Type;

public class Validator {
    private static ValidationException fail(String fmt, Object ... args) throws ValidationException {
        throw new ValidationException(String.format(fmt, args));
    }

    public static Method[] validate(byte[] codeBytes) throws IOException, ValidationException {
        byte[] classBytes;
        Method[] eeMethods;
        byte[] apisBytes = JarBuilder.getAPIsBytesFromJAR(codeBytes);
        if (apisBytes == null) {
            throw Validator.fail("Cannot get APIS", new Object[0]);
        }
        LoadedJar jar = LoadedJar.fromBytes(codeBytes);
        Map<String, byte[]> classMap = jar.classBytesByQualifiedNames;
        StructDB structDB = new StructDB(classMap);
        try {
            eeMethods = MethodUnpacker.readFrom(apisBytes);
        }
        catch (IOException e) {
            throw Validator.fail("bad APIS format", new Object[0]);
        }
        String cur = jar.mainClassName;
        HashMap<Member, MemberDecl> mmap = new HashMap<Member, MemberDecl>();
        while (cur != null && (classBytes = classMap.get(cur)) != null) {
            MethodCollector cv = ASM.accept(classBytes, new MethodCollector());
            for (MemberDecl m : cv.getMethodDecls()) {
                mmap.putIfAbsent(m.getMember(), m);
            }
            cur = Utilities.internalNameToFullyQualifiedName(cv.getSuperName());
        }
        HashSet<String> eeMethodNames = new HashSet<String>();
        for (Method eem : eeMethods) {
            Type[] pts;
            if (!eeMethodNames.add(eem.getName())) {
                throw Validator.fail("Duplicated external/event method %s", eem.getDebugName());
            }
            if (eem.getType() == 2) continue;
            MemberDecl m = (MemberDecl)mmap.get(new Member(eem.getName(), eem.getDescriptor()));
            if (m == null) {
                throw Validator.fail("No such method %s", eem.getDebugName());
            }
            if ((m.getAccess() & 1) == 0 || (m.getAccess() & 8) != 0) {
                throw Validator.fail("Non public or static method %s", eem.getDebugName());
            }
            Type mt = Type.getType((String)m.getDescriptor());
            Type rt = mt.getReturnType();
            if (!structDB.isValidReturnType(rt)) {
                throw Validator.fail("Invalid return type for method %s", eem.getDebugName());
            }
            if (eem.getOutput() != structDB.getEEPTypeFromReturnType(rt)) {
                throw Validator.fail("Incompatible return type for method %s", eem.getDebugName());
            }
            Method.Parameter[] eeParams = eem.getInputs();
            if (eeParams.length != (pts = mt.getArgumentTypes()).length) {
                throw Validator.fail("Bad param length in APIS for method %s", eem.getDebugName());
            }
            for (int i = 0; i < eeParams.length; ++i) {
                Method.Parameter eep = eeParams[i];
                Type pt = pts[i];
                Method.TypeDetail ptd = structDB.getDetailFromParameterType(pt);
                if (!eep.getTypeDetail().equals(ptd)) {
                    throw Validator.fail("Incompatible param %s for method %s", eep.getName(), eem.getDebugName());
                }
                if (structDB.isValidParamType(pt)) continue;
                throw Validator.fail("Invalid param %s for method %s", eep.getName(), eem.getDebugName());
            }
        }
        return eeMethods;
    }
}

