/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.types;

import java.math.BigInteger;
import java.util.Map;

public class StepCost {
    public static final String GET = "get";
    public static final String REPLACE = "replace";
    public static final String EVENT_LOG = "eventLog";
    public static final String DEFAULT_GET = "defaultGet";
    public static final String DEFAULT_SET = "defaultSet";
    public static final String REPLACE_BASE = "replaceBase";
    public static final String DEFAULT_DELETE = "defaultDelete";
    public static final String EVENT_LOG_BASE = "eventLogBase";
    private final Map<String, BigInteger> costMap;

    public StepCost(Map<String, BigInteger> costMap) {
        this.costMap = costMap;
    }

    public boolean has(String key) {
        return this.costMap.containsKey(key);
    }

    public int value(String key) {
        return this.costMap.getOrDefault(key, BigInteger.ZERO).intValue();
    }

    public int get() {
        return this.value(GET);
    }

    public int replace() {
        return this.value(REPLACE);
    }

    public int eventLog() {
        return this.value(EVENT_LOG);
    }

    public int defaultGet() {
        return this.value(DEFAULT_GET);
    }

    public int defaultSet() {
        return this.value(DEFAULT_SET);
    }

    public int replaceBase() {
        return this.value(REPLACE_BASE);
    }

    public int defaultDelete() {
        return this.value(DEFAULT_DELETE);
    }

    public int eventLogBase() {
        return this.value(EVENT_LOG_BASE);
    }
}

