/*
 * Decompiled with CFR 0.152.
 */
package i;

import e.s.java.lang.Throwable;
import i.AvmThrowable;
import i.FrameContext;
import i.IInstrumentation;
import i.InternedClasses;
import i.JvmError;
import i.OutOfEnergyException;
import i.OutOfStackException;
import i.RuntimeAssertionError;
import i.StackWatcher;
import java.util.IdentityHashMap;
import java.util.Stack;
import s.java.lang.String;
import score.ScoreRevertException;

public class CommonInstrumentation
implements IInstrumentation {
    private FrameState currentFrame;
    private final Stack<FrameState> callerFrames = new Stack();

    @Override
    public void enterNewFrame(ClassLoader contractLoader, long energyLeft, int nextHashCode, InternedClasses classWrappers, FrameContext frameContext) {
        RuntimeAssertionError.assertTrue(null != contractLoader);
        FrameState newFrame = new FrameState();
        newFrame.lateLoader = contractLoader;
        newFrame.energyLeft = energyLeft;
        newFrame.nextHashCode = nextHashCode;
        newFrame.frameContext = frameContext;
        if (1 == nextHashCode) {
            newFrame.internedStringWrappers = new IdentityHashMap();
        }
        newFrame.internedClassWrappers = classWrappers;
        newFrame.stackWatcher = new StackWatcher();
        newFrame.stackWatcher.setPolicy(3);
        newFrame.stackWatcher.setMaxStackDepth(512);
        newFrame.stackWatcher.setMaxStackSize(16384);
        if (null != this.currentFrame) {
            this.callerFrames.push(this.currentFrame);
        }
        this.currentFrame = newFrame;
    }

    @Override
    public void exitCurrentFrame() {
        FrameState returningFrame = null;
        if (!this.callerFrames.isEmpty()) {
            returningFrame = this.callerFrames.pop();
        }
        this.currentFrame = returningFrame;
    }

    @Override
    public <T> s.java.lang.Class<T> wrapAsClass(Class<T> input) {
        s.java.lang.Class<T> wrapper = null;
        if (null != input) {
            wrapper = this.currentFrame.internedClassWrappers.get(input);
        }
        return wrapper;
    }

    @Override
    public String wrapAsString(java.lang.String input) {
        String wrapper = null;
        if (null != input && null == (wrapper = this.currentFrame.internedStringWrappers.get(input))) {
            wrapper = new String(input);
            this.currentFrame.internedStringWrappers.put(input, wrapper);
        }
        return wrapper;
    }

    @Override
    public s.java.lang.Object unwrapThrowable(java.lang.Throwable t) {
        s.java.lang.Object shadow = null;
        AvmThrowable exceptionToRethrow = null;
        try {
            java.lang.String throwableName = t.getClass().getName();
            if (throwableName.startsWith("java.lang.") || throwableName.startsWith("score.")) {
                if (t instanceof VirtualMachineError) {
                    JvmError error = new JvmError((VirtualMachineError)t);
                    this.currentFrame.forceExitState = error;
                    exceptionToRethrow = error;
                } else {
                    shadow = t instanceof ScoreRevertException ? this.convertScoreRevertException((ScoreRevertException)t) : this.convertVmGeneratedException(t);
                }
            } else if (t instanceof AvmThrowable) {
                exceptionToRethrow = (AvmThrowable)t;
            } else {
                Throwable wrapper = (Throwable)t;
                shadow = (s.java.lang.Object)wrapper.unwrap();
            }
        }
        catch (java.lang.Throwable err) {
            throw RuntimeAssertionError.unexpected(err);
        }
        if (null != exceptionToRethrow) {
            throw exceptionToRethrow;
        }
        return shadow;
    }

    @Override
    public java.lang.Throwable wrapAsThrowable(s.java.lang.Object arg) {
        java.lang.Throwable result;
        try {
            java.lang.String objectClass = arg.getClass().getName();
            RuntimeAssertionError.assertTrue(this.isLoadedByCurrentClassLoader(arg.getClass()) || objectClass.startsWith("s."));
            java.lang.String wrapperClassName = "e." + objectClass;
            Class<?> wrapperClass = this.currentFrame.lateLoader.loadClass(wrapperClassName);
            result = (java.lang.Throwable)wrapperClass.getConstructor(Object.class).newInstance(arg);
        }
        catch (java.lang.Throwable err) {
            throw RuntimeAssertionError.unexpected(err);
        }
        return result;
    }

    @Override
    public void chargeEnergy(long cost) throws OutOfEnergyException {
        this.charge(cost, false);
    }

    @Override
    public void chargeEnergy(int cost) throws OutOfEnergyException {
        this.charge(cost, false);
    }

    @Override
    public void chargeEnergyImmediately(int cost) throws OutOfEnergyException {
        this.charge(cost, true);
    }

    @Override
    public boolean tryChargeEnergy(int cost) {
        if (null != this.currentFrame.forceExitState) {
            throw this.currentFrame.forceExitState;
        }
        RuntimeAssertionError.assertTrue((double)cost < Math.pow(2.0, 30.0));
        while (this.currentFrame.energyLeft < (long)cost) {
            if (this.currentFrame.frameContext.waitForRefund()) continue;
            return false;
        }
        this.currentFrame.energyLeft -= (long)cost;
        return true;
    }

    private void charge(long cost, boolean immediate) throws OutOfEnergyException {
        if (null != this.currentFrame.forceExitState) {
            throw this.currentFrame.forceExitState;
        }
        while (this.currentFrame.energyLeft < cost) {
            if (!immediate && this.currentFrame.frameContext.waitForRefund()) continue;
            this.currentFrame.energyLeft = 0L;
            OutOfEnergyException error = new OutOfEnergyException();
            this.currentFrame.forceExitState = error;
            throw error;
        }
        this.currentFrame.energyLeft -= cost;
    }

    @Override
    public long energyLeft() {
        return this.currentFrame.energyLeft;
    }

    @Override
    public int getNextHashCodeAndIncrement() {
        return this.currentFrame.nextHashCode++;
    }

    @Override
    public int getCurStackSize() {
        return this.currentFrame.stackWatcher.getCurStackSize();
    }

    @Override
    public int getCurStackDepth() {
        return this.currentFrame.stackWatcher.getCurStackDepth();
    }

    @Override
    public void enterMethod(int frameSize) {
        if (null != this.currentFrame.forceExitState) {
            throw this.currentFrame.forceExitState;
        }
        try {
            this.currentFrame.stackWatcher.enterMethod(frameSize);
        }
        catch (OutOfStackException ex) {
            this.currentFrame.forceExitState = ex;
        }
    }

    @Override
    public void exitMethod(int frameSize) {
        if (null != this.currentFrame.forceExitState) {
            throw this.currentFrame.forceExitState;
        }
        try {
            this.currentFrame.stackWatcher.exitMethod(frameSize);
        }
        catch (OutOfStackException ex) {
            this.currentFrame.forceExitState = ex;
        }
    }

    @Override
    public void enterCatchBlock(int depth, int size) {
        if (null != this.currentFrame.forceExitState) {
            throw this.currentFrame.forceExitState;
        }
        try {
            this.currentFrame.stackWatcher.enterCatchBlock(depth, size);
        }
        catch (OutOfStackException ex) {
            this.currentFrame.forceExitState = ex;
        }
    }

    @Override
    public int peekNextHashCode() {
        return this.currentFrame.nextHashCode;
    }

    @Override
    public void forceNextHashCode(int nextHashCode) {
        this.currentFrame.nextHashCode = nextHashCode;
    }

    @Override
    public void bootstrapOnly() {
        throw RuntimeAssertionError.unreachable("NOT a bootstrap IInstrumentation");
    }

    @Override
    public boolean isLoadedByCurrentClassLoader(Class<?> userClass) {
        return userClass.getClassLoader() == this.currentFrame.lateLoader;
    }

    private s.java.lang.Throwable convertScoreRevertException(ScoreRevertException t) throws Exception {
        int code = t.getCode();
        java.lang.Throwable originalCause = t.getCause();
        s.java.lang.Throwable cause = null != originalCause ? this.convertVmGeneratedException(originalCause) : null;
        java.lang.String throwableName = t.getClass().getName();
        Class<?> shadowClass = this.currentFrame.lateLoader.loadClass("s." + throwableName);
        s.java.lang.Throwable res = (s.java.lang.Throwable)shadowClass.getConstructor(Integer.TYPE, String.class, s.java.lang.Throwable.class).newInstance(code, null, cause);
        res.setSystemMessage(t.getMessage());
        res.setStackTrace(t.getStackTrace());
        return res;
    }

    private s.java.lang.Throwable convertVmGeneratedException(java.lang.Throwable t) throws Exception {
        java.lang.Throwable originalCause = t.getCause();
        s.java.lang.Throwable cause = null != originalCause ? this.convertVmGeneratedException(originalCause) : null;
        java.lang.String throwableName = t.getClass().getName();
        Class<?> shadowClass = this.currentFrame.lateLoader.loadClass("s." + throwableName);
        s.java.lang.Throwable res = (s.java.lang.Throwable)shadowClass.getConstructor(String.class, s.java.lang.Throwable.class).newInstance(null, cause);
        res.setSystemMessage(t.getMessage());
        res.setStackTrace(t.getStackTrace());
        return res;
    }

    @Override
    public FrameContext getFrameContext() {
        return this.currentFrame.frameContext;
    }

    public static class FrameState {
        public StackWatcher stackWatcher;
        private ClassLoader lateLoader;
        private long energyLeft;
        private int nextHashCode;
        private IdentityHashMap<java.lang.String, String> internedStringWrappers;
        private InternedClasses internedClassWrappers;
        private AvmThrowable forceExitState;
        private FrameContext frameContext;
    }
}

