/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm;

import i.RuntimeAssertionError;
import org.aion.avm.ArrayUtil;
import org.aion.avm.NameStyle;

public final class ArrayRenamer {
    private static final String BASIC_DOT_WRAPPER = "a.";
    private static final String BASIC_SLASH_WRAPPER = "a/";
    private static final String UNIFYING_DOT_WRAPPER = "w.";
    private static final String UNIFYING_SLASH_WRAPPER = "w/";

    public static String prependArrayWrapperPrefix(NameStyle style, String name) {
        RuntimeAssertionError.assertTrue(style != null);
        RuntimeAssertionError.assertTrue(name != null);
        return (style == NameStyle.DOT_NAME ? BASIC_DOT_WRAPPER : BASIC_SLASH_WRAPPER) + name;
    }

    public static String prependUnifyingArrayWrapperPrefix(NameStyle style, String name) {
        RuntimeAssertionError.assertTrue(style != null);
        RuntimeAssertionError.assertTrue(name != null);
        return (style == NameStyle.DOT_NAME ? UNIFYING_DOT_WRAPPER : UNIFYING_SLASH_WRAPPER) + name;
    }

    public static String wrapAsConcreteObjectArray(NameStyle style, String underlyingType, int dimension) {
        RuntimeAssertionError.assertTrue(underlyingType != null);
        if (dimension > 0) {
            String unwrappedName = ArrayRenamer.stringOfSameCharacter('$', dimension) + "L" + underlyingType;
            return ArrayRenamer.prependArrayWrapperPrefix(style, unwrappedName);
        }
        throw RuntimeAssertionError.unreachable("Expected dimension of at least 1: " + dimension);
    }

    public static String wrapAsUnifyingObjectArray(NameStyle style, String underlyingType, int dimension) {
        RuntimeAssertionError.assertTrue(underlyingType != null);
        if (dimension > 0) {
            String unwrappedName = ArrayRenamer.stringOfSameCharacter('_', dimension) + "L" + underlyingType;
            return ArrayRenamer.prependUnifyingArrayWrapperPrefix(style, unwrappedName);
        }
        throw RuntimeAssertionError.unreachable("Expected dimension of at least 1: " + dimension);
    }

    public static String stripArrayWrapperPrefix(NameStyle style, String array) {
        String unifyingPrefix;
        RuntimeAssertionError.assertTrue(style != null);
        RuntimeAssertionError.assertTrue(array != null);
        String basicPrefix = style == NameStyle.DOT_NAME ? BASIC_DOT_WRAPPER : BASIC_SLASH_WRAPPER;
        String string = unifyingPrefix = style == NameStyle.DOT_NAME ? UNIFYING_DOT_WRAPPER : UNIFYING_SLASH_WRAPPER;
        if (array.startsWith(unifyingPrefix)) {
            return array.substring(unifyingPrefix.length());
        }
        if (array.startsWith(basicPrefix)) {
            return array.substring(basicPrefix.length());
        }
        throw RuntimeAssertionError.unreachable("Expected an array wrapper: " + array);
    }

    public static String getPostRenameObjectArrayWrapperUnderlyingTypeName(NameStyle style, String array) {
        RuntimeAssertionError.assertTrue(ArrayUtil.isPostRenameObjectArray(style, array));
        int dimension = ArrayUtil.dimensionOfPostRenameObjectArray(style, array);
        String strippedName = ArrayRenamer.stripArrayWrapperPrefix(style, array);
        return strippedName.substring(dimension + 1);
    }

    public static String getPreRenameObjectArrayWrapperUnderlyingTypeName(String array) {
        RuntimeAssertionError.assertTrue(ArrayUtil.isPreRenameObjectArray(array));
        int dimension = ArrayUtil.dimensionOfPreRenameObjectArray(array);
        return array.substring(dimension + 1);
    }

    public static String prependPreRenameObjectArrayPrefix(String baseType, int dimension) {
        String leadingDimensionChars = ArrayRenamer.stringOfSameCharacter('[', dimension);
        return leadingDimensionChars + "L" + baseType;
    }

    private static String stringOfSameCharacter(char character, int length) {
        if (character == '$') {
            return new String(new char[length]).replaceAll("\u0000", "\\$");
        }
        if (character == '[') {
            return new String(new char[length]).replaceAll("\u0000", "\\[");
        }
        return new String(new char[length]).replaceAll("\u0000", String.valueOf(character));
    }
}

