/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm;

import a.BooleanArray;
import a.ByteArray;
import a.CharArray;
import a.DoubleArray;
import a.FloatArray;
import a.IntArray;
import a.LongArray;
import a.ShortArray;
import i.RuntimeAssertionError;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aion.avm.ArrayRenamer;
import org.aion.avm.NameStyle;

public final class ArrayUtil {
    private static final String DOT_PREFIX = "a.";
    private static final String SLASH_PREFIX = "a/";
    private static final Pattern PRE_RENAME_PRIMITIVE_1D = Pattern.compile("^\\[[IBZCFSJD]$");
    private static final Pattern PRE_RENAME_PRIMITIVE_MD = Pattern.compile("^\\[{2,}[IBZCFSJD]$");
    private static final Pattern PRE_RENAME_OBJECT = Pattern.compile("^\\[+L.+");
    private static final Pattern POST_RENAME_CONCRETE_DOT = Pattern.compile("^a.\\$+L.+");
    private static final Pattern POST_RENAME_CONCRETE_SLASH = Pattern.compile("^a/\\$+L.+");
    private static final Pattern POST_RENAME_UNIFYING_DOT = Pattern.compile("^w._+L.+");
    private static final Pattern POST_RENAME_UNIFYING_SLASH = Pattern.compile("^w/_+L.+");
    private static Set<String> postRenamePrimitiveSimpleNames = Stream.of(IntArray.class.getSimpleName(), LongArray.class.getSimpleName(), ByteArray.class.getSimpleName(), BooleanArray.class.getSimpleName(), ShortArray.class.getSimpleName(), DoubleArray.class.getSimpleName(), FloatArray.class.getSimpleName(), CharArray.class.getSimpleName()).collect(Collectors.toSet());
    private static Set<Character> primitiveSignifiers = Stream.of(Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('Z'), Character.valueOf('B'), Character.valueOf('S'), Character.valueOf('D'), Character.valueOf('F'), Character.valueOf('C')).collect(Collectors.toSet());

    public static boolean isPreRenameSingleDimensionPrimitiveArray(String array) {
        RuntimeAssertionError.assertTrue(array != null);
        return PRE_RENAME_PRIMITIVE_1D.matcher(array).matches();
    }

    public static boolean isPreRenameMultiDimensionPrimitiveArray(String array) {
        RuntimeAssertionError.assertTrue(array != null);
        return PRE_RENAME_PRIMITIVE_MD.matcher(array).matches();
    }

    public static boolean isPreRenamePrimitiveArray(String array) {
        return ArrayUtil.isPreRenameSingleDimensionPrimitiveArray(array) || ArrayUtil.isPreRenameMultiDimensionPrimitiveArray(array);
    }

    public static boolean isPreRenameObjectArray(String array) {
        RuntimeAssertionError.assertTrue(array != null);
        return PRE_RENAME_OBJECT.matcher(array).matches();
    }

    public static boolean isPreRenameArray(String array) {
        return ArrayUtil.isPreRenamePrimitiveArray(array) || ArrayUtil.isPreRenameObjectArray(array);
    }

    public static boolean isPostRenameSingleDimensionPrimitiveArray(NameStyle style, String array) {
        String prefix;
        String unwantedCharacter = style == NameStyle.DOT_NAME ? "/" : ".";
        RuntimeAssertionError.assertTrue(!array.contains(unwantedCharacter));
        String string = prefix = style == NameStyle.DOT_NAME ? DOT_PREFIX : SLASH_PREFIX;
        if (!array.startsWith(prefix)) {
            return false;
        }
        String strippedName = array.substring(prefix.length());
        return postRenamePrimitiveSimpleNames.contains(strippedName);
    }

    public static boolean isPostRenameMultiDimensionPrimitiveArray(NameStyle style, String array) {
        String prefix;
        String unwantedCharacter = style == NameStyle.DOT_NAME ? "/" : ".";
        RuntimeAssertionError.assertTrue(!array.contains(unwantedCharacter));
        String string = prefix = style == NameStyle.DOT_NAME ? DOT_PREFIX : SLASH_PREFIX;
        if (!array.startsWith(prefix)) {
            return false;
        }
        String strippedName = array.substring(prefix.length());
        int dimension = ArrayUtil.numberOfLeading('$', strippedName);
        if (dimension < 1) {
            return false;
        }
        char lastChar = strippedName.charAt(strippedName.length() - 1);
        return strippedName.length() == dimension + 1 && primitiveSignifiers.contains(Character.valueOf(lastChar));
    }

    public static boolean isPostRenamePrimitiveArray(NameStyle style, String array) {
        return ArrayUtil.isPostRenameSingleDimensionPrimitiveArray(style, array) || ArrayUtil.isPostRenameMultiDimensionPrimitiveArray(style, array);
    }

    public static boolean isPostRenameConcreteTypeObjectArray(NameStyle style, String array) {
        RuntimeAssertionError.assertTrue(style != null);
        RuntimeAssertionError.assertTrue(array != null);
        return style == NameStyle.DOT_NAME ? POST_RENAME_CONCRETE_DOT.matcher(array).matches() : POST_RENAME_CONCRETE_SLASH.matcher(array).matches();
    }

    public static boolean isPostRenameUnifyingTypeObjectArray(NameStyle style, String array) {
        RuntimeAssertionError.assertTrue(style != null);
        RuntimeAssertionError.assertTrue(array != null);
        return style == NameStyle.DOT_NAME ? POST_RENAME_UNIFYING_DOT.matcher(array).matches() : POST_RENAME_UNIFYING_SLASH.matcher(array).matches();
    }

    public static boolean isPostRenameObjectArray(NameStyle style, String array) {
        return ArrayUtil.isPostRenameConcreteTypeObjectArray(style, array) || ArrayUtil.isPostRenameUnifyingTypeObjectArray(style, array);
    }

    public static boolean isPostRenameArray(NameStyle style, String array) {
        return ArrayUtil.isPostRenamePrimitiveArray(style, array) || ArrayUtil.isPostRenameObjectArray(style, array) || ArrayUtil.isSpecialPostRenameArray(style, array);
    }

    public static boolean isSpecialPostRenameArray(NameStyle style, String array) {
        String internalPrefix;
        String prefix = style == NameStyle.DOT_NAME ? DOT_PREFIX : SLASH_PREFIX;
        String string = internalPrefix = style == NameStyle.DOT_NAME ? "i." : "i/";
        return array.equals(prefix + "ObjectArray") || array.equals(internalPrefix + "IObjectArray") || array.equals(prefix + "Array") || array.equals(prefix + "IArray");
    }

    public static boolean isSingleDimensionalPrimitiveArray(NameStyle style, String array) {
        return ArrayUtil.isPreRenameSingleDimensionPrimitiveArray(array) || ArrayUtil.isPostRenameSingleDimensionPrimitiveArray(style, array);
    }

    public static boolean isMultiDimensionalPrimitiveArray(NameStyle style, String array) {
        return ArrayUtil.isPreRenameMultiDimensionPrimitiveArray(array) || ArrayUtil.isPostRenameMultiDimensionPrimitiveArray(style, array);
    }

    public static boolean isPrimitiveArray(NameStyle style, String array) {
        return ArrayUtil.isPreRenamePrimitiveArray(array) || ArrayUtil.isPostRenamePrimitiveArray(style, array);
    }

    public static boolean isObjectArray(NameStyle style, String array) {
        return ArrayUtil.isPreRenameObjectArray(array) || ArrayUtil.isPostRenameObjectArray(style, array);
    }

    public static boolean isArray(NameStyle style, String array) {
        return ArrayUtil.isPreRenameArray(array) || ArrayUtil.isPostRenameArray(style, array);
    }

    public static int dimensionOfPreRenamePrimitiveArray(String array) {
        RuntimeAssertionError.assertTrue(ArrayUtil.isPreRenamePrimitiveArray(array));
        return ArrayUtil.numberOfLeading('[', array);
    }

    public static int dimensionOfPreRenameObjectArray(String array) {
        RuntimeAssertionError.assertTrue(ArrayUtil.isPreRenameObjectArray(array));
        return ArrayUtil.numberOfLeading('[', array);
    }

    public static int dimensionOfPreRenameArray(String array) {
        if (ArrayUtil.isPreRenamePrimitiveArray(array)) {
            return ArrayUtil.dimensionOfPreRenamePrimitiveArray(array);
        }
        if (ArrayUtil.isPreRenameObjectArray(array)) {
            return ArrayUtil.dimensionOfPreRenameObjectArray(array);
        }
        throw RuntimeAssertionError.unreachable("Expected pre-rename array: " + array);
    }

    private static int dimensionOfPostRenameMultiDimensionPrimitiveArray(NameStyle style, String array) {
        String unwrappedArray = ArrayRenamer.stripArrayWrapperPrefix(style, array);
        return ArrayUtil.numberOfLeading('$', unwrappedArray);
    }

    public static int dimensionOfPostRenamePrimitiveArray(NameStyle style, String array) {
        if (ArrayUtil.isPostRenameSingleDimensionPrimitiveArray(style, array)) {
            return 1;
        }
        if (ArrayUtil.isPostRenameMultiDimensionPrimitiveArray(style, array)) {
            return ArrayUtil.dimensionOfPostRenameMultiDimensionPrimitiveArray(style, array);
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename primitive array: " + array);
    }

    private static int dimensionOfPostRenameConcreteTypeObjectArray(NameStyle style, String array) {
        String unwrappedArray = ArrayRenamer.stripArrayWrapperPrefix(style, array);
        return ArrayUtil.numberOfLeading('$', unwrappedArray);
    }

    private static int dimensionOfPostRenameUnifyingTypeObjectArray(NameStyle style, String array) {
        String unwrappedArray = ArrayRenamer.stripArrayWrapperPrefix(style, array);
        return ArrayUtil.numberOfLeading('_', unwrappedArray);
    }

    public static int dimensionOfPostRenameObjectArray(NameStyle style, String array) {
        if (ArrayUtil.isPostRenameConcreteTypeObjectArray(style, array)) {
            return ArrayUtil.dimensionOfPostRenameConcreteTypeObjectArray(style, array);
        }
        if (ArrayUtil.isPostRenameUnifyingTypeObjectArray(style, array)) {
            return ArrayUtil.dimensionOfPostRenameUnifyingTypeObjectArray(style, array);
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename object array: " + array);
    }

    public static int dimensionOfPostRenameArray(NameStyle style, String array) {
        if (ArrayUtil.isPostRenamePrimitiveArray(style, array)) {
            return ArrayUtil.dimensionOfPostRenamePrimitiveArray(style, array);
        }
        if (ArrayUtil.isPostRenameObjectArray(style, array)) {
            return ArrayUtil.dimensionOfPostRenameObjectArray(style, array);
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename array: " + array);
    }

    public static int dimensionOfArray(NameStyle style, String array) {
        if (ArrayUtil.isPreRenameArray(array)) {
            return ArrayUtil.dimensionOfPreRenameArray(array);
        }
        if (ArrayUtil.isPostRenameArray(style, array)) {
            return ArrayUtil.dimensionOfPostRenameArray(style, array);
        }
        throw RuntimeAssertionError.unreachable("Expected array: " + array);
    }

    private static int numberOfLeading(char leadingChar, String string) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != leadingChar) {
                return count;
            }
            ++count;
        }
        return count;
    }
}

