/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aion.avm.core.dappreading.LoadedJar;
import org.aion.avm.core.types.ClassInfo;
import org.aion.avm.core.types.Forest;
import org.aion.avm.core.types.Pair;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class ClassHierarchyForest
extends Forest<String, ClassInfo> {
    private final LoadedJar loadedJar;

    public Map<String, ClassInfo> toFlatMapWithoutRoots() {
        FlatMapCollector collector = new FlatMapCollector(this.getNodesCount());
        this.walkPreOrder(collector);
        return collector.getMap();
    }

    public static ClassHierarchyForest createForestFrom(LoadedJar loadedJar) throws IOException {
        ClassHierarchyForest forest = new ClassHierarchyForest(loadedJar);
        forest.createForestInternal();
        return forest;
    }

    private ClassHierarchyForest(LoadedJar loadedJar) {
        this.loadedJar = loadedJar;
    }

    private void createForestInternal() throws IOException {
        Map<String, byte[]> classNameToBytes = this.loadedJar.classBytesByQualifiedNames;
        for (Map.Entry<String, byte[]> entry : classNameToBytes.entrySet()) {
            Pair<String, ClassInfo> pair = this.analyzeClass(entry.getValue());
            if (!((ClassInfo)pair.value).isInterface()) {
                String parentName = (String)pair.key;
                byte[] parentBytes = classNameToBytes.get(parentName);
                ClassInfo parentInfo = parentBytes != null ? (ClassInfo)this.analyzeClass((byte[])parentBytes).value : new ClassInfo(false, null);
                Forest.Node<String, ClassInfo> parentNode = new Forest.Node<String, ClassInfo>(parentName, parentInfo);
                Forest.Node<String, ClassInfo> childNode = new Forest.Node<String, ClassInfo>(entry.getKey(), (ClassInfo)pair.value);
                this.add(parentNode, childNode);
                continue;
            }
            Forest.Node<String, ClassInfo> parentNode = new Forest.Node<String, ClassInfo>(Object.class.getName(), new ClassInfo(false, null));
            Forest.Node<String, ClassInfo> childNode = new Forest.Node<String, ClassInfo>(entry.getKey(), (ClassInfo)pair.value);
            this.add(parentNode, childNode);
        }
    }

    private Pair<String, ClassInfo> analyzeClass(byte[] klass) {
        ClassReader reader = new ClassReader(klass);
        CodeVisitor codeVisitor = new CodeVisitor();
        reader.accept((ClassVisitor)codeVisitor, 4);
        String parent = codeVisitor.getParentQualifiedName();
        boolean isInterface = codeVisitor.isInterface();
        return Pair.of(parent, new ClassInfo(isInterface, klass));
    }

    private static final class FlatMapCollector
    extends Forest.VisitorAdapter<String, ClassInfo> {
        private final Map<String, ClassInfo> map;

        private FlatMapCollector(int size) {
            this.map = new HashMap<String, ClassInfo>(size);
        }

        @Override
        public void onVisitNotRootNode(Forest.Node<String, ClassInfo> node) {
            this.map.put(node.getId(), node.getContent());
        }

        private Map<String, ClassInfo> getMap() {
            return Collections.unmodifiableMap(this.map);
        }
    }

    private static final class CodeVisitor
    extends ClassVisitor {
        private String parentQualifiedName;
        private boolean isInterface;

        private CodeVisitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.parentQualifiedName = CodeVisitor.toQualifiedName(superName);
            this.isInterface = 512 == (access & 0x200);
        }

        public void visitSource(String source, String debug) {
            super.visitSource(source, debug);
        }

        public void visitAttribute(Attribute attribute) {
            super.visitAttribute(attribute);
        }

        private boolean isInterface() {
            return this.isInterface;
        }

        private String getParentQualifiedName() {
            return this.parentQualifiedName;
        }

        private static String toQualifiedName(String internalClassName) {
            return internalClassName.replaceAll("/", ".");
        }
    }
}

