/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import foundation.icon.ee.score.Transformer;
import foundation.icon.ee.types.Address;
import foundation.icon.ee.types.DAppRuntimeState;
import foundation.icon.ee.types.ObjectGraph;
import foundation.icon.ee.types.Result;
import foundation.icon.ee.types.Transaction;
import i.AvmError;
import i.AvmException;
import i.AvmThrowable;
import i.IBlockchainRuntime;
import i.IInstrumentation;
import i.IRuntimeSetup;
import i.InstrumentationHelpers;
import org.aion.avm.core.AvmConfiguration;
import org.aion.avm.core.BlockchainRuntimeImpl;
import org.aion.avm.core.DAppLoader;
import org.aion.avm.core.FrameContextImpl;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.ReentrantDAppStack;
import org.aion.avm.core.persistence.LoadedDApp;
import org.aion.avm.core.types.TransformedDappModule;
import org.aion.parallel.TransactionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAppCreator {
    private static final Logger logger = LoggerFactory.getLogger(DAppCreator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Result create(IExternalState externalState, TransactionTask task, Address senderAddress, Address dappAddress, Transaction tx, AvmConfiguration conf) throws AvmError {
        Result result;
        IRuntimeSetup runtimeSetup = null;
        IBlockchainRuntime previousRuntime = null;
        LoadedDApp dapp = null;
        try {
            Transformer transformer = new Transformer(externalState, conf);
            transformer.transform();
            TransformedDappModule transformedDapp = transformer.getBootstrapModule();
            dapp = DAppLoader.fromTransformed(transformedDapp, transformer.getAPIsBytes(), conf.preserveDebuggability);
            runtimeSetup = dapp.runtimeSetup;
            int nextHashCode = 1;
            ReentrantDAppStack.ReentrantState prevState = task.getReentrantDAppStack().getTop();
            task.getReentrantDAppStack().pushState();
            ReentrantDAppStack.ReentrantState thisState = task.getReentrantDAppStack().getTop();
            BlockchainRuntimeImpl br = new BlockchainRuntimeImpl(externalState, task, senderAddress, dappAddress, tx, runtimeSetup, dapp, conf.enableContextPrintln);
            FrameContextImpl fc = new FrameContextImpl(externalState);
            InstrumentationHelpers.pushNewStackFrame(runtimeSetup, dapp.loader, tx.getLimit(), nextHashCode, dapp.getInternedClasses(), fc);
            previousRuntime = dapp.attachBlockchainRuntime(br);
            externalState.setTransformedCode(transformer.getTransformedCodeBytes());
            IInstrumentation threadInstrumentation = IInstrumentation.attachedThreadInstrumentation.get();
            result = DAppCreator.runClinitAndCreateMainInstance(dapp, threadInstrumentation, externalState, tx);
            if (prevState != null) {
                prevState.inherit(thisState);
                DAppRuntimeState newRS = dapp.saveRuntimeState();
                prevState.setRuntimeState(task.getEID(), newRS, externalState.getContractID());
                task.getReentrantDAppStack().cacheDApp(dapp, externalState.getContractID(), externalState.getCodeID());
            }
            if (null == runtimeSetup) return result;
        }
        catch (AvmException e) {
            try {
                logger.trace("DApp deployment failed: {}", (Object)e.getMessage());
                if (conf.enableVerboseContractErrors) {
                    e.printStackTrace();
                }
                long stepUsed = runtimeSetup != null ? tx.getLimit() - IInstrumentation.getEnergyLeft() : 0L;
                result = new Result(e.getCode(), stepUsed, (Object)e.getResultMessage());
                if (null == runtimeSetup) return result;
            }
            catch (Throwable throwable) {
                if (null == runtimeSetup) throw throwable;
                InstrumentationHelpers.popExistingStackFrame(runtimeSetup);
                task.getReentrantDAppStack().popState();
                dapp.attachBlockchainRuntime(previousRuntime);
                throw throwable;
            }
            InstrumentationHelpers.popExistingStackFrame(runtimeSetup);
            task.getReentrantDAppStack().popState();
            dapp.attachBlockchainRuntime(previousRuntime);
            return result;
        }
        InstrumentationHelpers.popExistingStackFrame(runtimeSetup);
        task.getReentrantDAppStack().popState();
        dapp.attachBlockchainRuntime(previousRuntime);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result runClinitAndCreateMainInstance(LoadedDApp dapp, IInstrumentation threadInstrumentation, IExternalState externalState, Transaction tx) throws AvmThrowable {
        try {
            dapp.forceInitializeAllClasses();
            dapp.initMainInstance(tx.getParams());
        }
        finally {
            externalState.waitForCallbacks();
        }
        ObjectGraph og = dapp.saveRuntimeState().getGraph();
        byte[] rawGraphData = og.getGraphData();
        int effectiveLen = Math.max(externalState.getStepCost().replaceBase(), rawGraphData.length);
        threadInstrumentation.chargeEnergy(effectiveLen * externalState.getStepCost().replace());
        externalState.putObjectGraph(og);
        long energyUsed = tx.getLimit() - threadInstrumentation.energyLeft();
        return new Result(0, energyUsed, null);
    }
}

