/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import foundation.icon.ee.types.StepCost;
import i.IDBStorage;
import i.IInstrumentation;
import java.math.BigInteger;
import org.aion.avm.core.IExternalState;

public class DBStorage
implements IDBStorage {
    private final IExternalState ctx;

    public DBStorage(IExternalState ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setArrayLength(byte[] key, int l) {
        byte[] v = l == 0 ? null : BigInteger.valueOf(l).toByteArray();
        this.setBytes(key, v);
    }

    @Override
    public int getArrayLength(byte[] key) {
        byte[] bs = this.getBytes(key);
        if (bs == null) {
            return 0;
        }
        return new BigInteger(bs).intValue();
    }

    private void charge(int cost) {
        IInstrumentation.attachedThreadInstrumentation.get().chargeEnergy(cost);
    }

    private void chargeImmediately(int cost) {
        IInstrumentation.attachedThreadInstrumentation.get().chargeEnergyImmediately(cost);
    }

    private boolean tryCharge(int cost) {
        return IInstrumentation.attachedThreadInstrumentation.get().tryChargeEnergy(cost);
    }

    @Override
    public void setBytes(byte[] k, byte[] v) {
        if (this.ctx.isReadOnly()) {
            throw new IllegalStateException();
        }
        StepCost stepCost = this.ctx.getStepCost();
        if (v == null) {
            int r = stepCost.replaceBase() * stepCost.replace();
            if (this.tryCharge(r)) {
                this.ctx.putStorage(k, null, prevSize -> {
                    if (prevSize >= 0) {
                        this.chargeImmediately(-r + stepCost.defaultDelete());
                    }
                });
            } else {
                byte[] prev = this.ctx.getStorage(k);
                if (prev != null) {
                    this.chargeImmediately(stepCost.defaultDelete());
                } else {
                    this.chargeImmediately(r);
                }
                this.ctx.putStorage(k, null, null);
            }
        } else {
            int r = Math.max(stepCost.replaceBase(), v.length) * stepCost.replace();
            if (this.tryCharge(r + stepCost.defaultSet())) {
                this.ctx.putStorage(k, v, prevSize -> {
                    if (prevSize >= 0) {
                        this.chargeImmediately(-stepCost.defaultSet());
                    }
                });
            } else {
                byte[] prev = this.ctx.getStorage(k);
                if (prev != null) {
                    this.chargeImmediately(r);
                } else {
                    this.chargeImmediately(r + stepCost.defaultSet());
                }
                this.ctx.putStorage(k, v, null);
            }
        }
    }

    @Override
    public byte[] getBytes(byte[] key) {
        byte[] value = this.ctx.getStorage(key);
        StepCost stepCost = this.ctx.getStepCost();
        int len = 0;
        if (value != null) {
            len = value.length;
        }
        this.charge(stepCost.defaultGet() + len * stepCost.get());
        return value;
    }

    @Override
    public void flush() {
    }
}

