/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.classgeneration;

import i.RuntimeAssertionError;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aion.avm.ClassNameExtractor;
import org.aion.avm.core.classgeneration.StubGenerator;
import org.aion.avm.core.types.CommonType;

public class CommonGenerators {
    public static final String[] kExceptionClassNames = (String[])Arrays.stream(CommonType.values()).filter(type -> type.isShadowException && !type.isVirtualMachineErrorOrChildError && !type.dotName.equals(CommonType.SHADOW_THROWABLE.dotName)).map(type -> ClassNameExtractor.getOriginalClassName(type.dotName)).toArray(String[]::new);
    public static final Set<String> kHandWrittenExceptionClassNames = Set.of(new String[]{ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_ERROR.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_ASSERTION_ERROR.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_EXCEPTION.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_RUNTIME_EXCEPTION.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_ENUM_CONSTANT_EXCEPTION.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_NO_TYPE_PRESENT_EXCEPTION.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_NO_SUCH_ELEMENT_EXCEPTION.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_REVERT_EXCEPTION.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_SCORE_REVERT_EXCEPTION.dotName)});
    public static final Set<String> kLegacyExceptionClassNames = Set.of(new String[]{ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_INITIALIZER_ERROR.dotName), ClassNameExtractor.getOriginalClassName(CommonType.SHADOW_CLASS_NOT_FOUND_EXCEPTION.dotName)});
    public static Map<String, String> parentClassMap;

    public static Map<String, byte[]> generateShadowJDK() {
        HashMap<String, byte[]> shadowJDK = new HashMap<String, byte[]>();
        Map<String, byte[]> shadowException = CommonGenerators.generateShadowException();
        shadowJDK.putAll(shadowException);
        return shadowJDK;
    }

    public static Map<String, byte[]> generateShadowException() {
        HashMap<String, byte[]> generatedClasses = new HashMap<String, byte[]>();
        parentClassMap = new HashMap<String, String>();
        for (String className : kExceptionClassNames) {
            String superclassName = null;
            try {
                superclassName = Class.forName(className).getSuperclass().getName();
            }
            catch (ClassNotFoundException e) {
                throw RuntimeAssertionError.unexpected(e);
            }
            if (!kHandWrittenExceptionClassNames.contains(className)) {
                String shadowName = "s." + className;
                String shadowSuperName = "s." + superclassName;
                byte[] shadowBytes = null;
                shadowBytes = kLegacyExceptionClassNames.contains(className) ? CommonGenerators.generateLegacyExceptionClass(shadowName, shadowSuperName) : CommonGenerators.generateExceptionClass(shadowName, shadowSuperName);
                generatedClasses.put(shadowName, shadowBytes);
                parentClassMap.put(shadowName, shadowSuperName);
            }
            String wrapperName = "e.s." + className;
            String wrapperSuperName = "e.s." + superclassName;
            byte[] wrapperBytes = CommonGenerators.generateWrapperClass(wrapperName, wrapperSuperName);
            generatedClasses.put(wrapperName, wrapperBytes);
        }
        return generatedClasses;
    }

    private static byte[] generateWrapperClass(String mappedName, String mappedSuperName) {
        String slashName = mappedName.replaceAll("\\.", "/");
        String superSlashName = mappedSuperName.replaceAll("\\.", "/");
        return StubGenerator.generateWrapperClass(slashName, superSlashName);
    }

    private static byte[] generateExceptionClass(String mappedName, String mappedSuperName) {
        String slashName = mappedName.replaceAll("\\.", "/");
        String superSlashName = mappedSuperName.replaceAll("\\.", "/");
        return StubGenerator.generateExceptionClass(slashName, superSlashName);
    }

    private static byte[] generateLegacyExceptionClass(String mappedName, String mappedSuperName) {
        String slashName = mappedName.replaceAll("\\.", "/");
        String superSlashName = mappedSuperName.replaceAll("\\.", "/");
        return StubGenerator.generateLegacyExceptionClass(slashName, superSlashName);
    }
}

