/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.classloading;

import i.RuntimeAssertionError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.aion.avm.core.arraywrapping.ArrayWrappingClassGenerator;
import org.aion.avm.core.classloading.AvmClassLoader;

public class AvmSharedClassLoader
extends ClassLoader {
    private final Map<String, byte[]> bytecodeMap;
    private final Map<String, Class<?>> cacheStatic;
    private final Map<String, Class<?>> cacheDynamic;
    private ArrayList<Function<String, byte[]>> handlers;
    private boolean initialized = false;

    public AvmSharedClassLoader(Map<String, byte[]> bytecodeMap) {
        super(AvmClassLoader.class.getClassLoader());
        this.bytecodeMap = bytecodeMap;
        this.cacheStatic = new HashMap();
        this.cacheDynamic = new HashMap();
        this.handlers = new ArrayList();
        this.registerHandlers();
    }

    private void registerHandlers() {
        Function<String, byte[]> wrapperGenerator = cName -> ArrayWrappingClassGenerator.arrayWrappingFactory(cName, this);
        this.handlers.add(wrapperGenerator);
    }

    public void putIntoDynamicCache(Class<?>[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            this.cacheDynamic.putIfAbsent(classes[i].getName(), classes[i]);
        }
    }

    public void putIntoStaticCache(Class<?>[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            this.cacheStatic.putIfAbsent(classes[i].getName(), classes[i]);
        }
    }

    public void finishInitialization() {
        for (String name : this.bytecodeMap.keySet()) {
            try {
                this.loadClass(name, true);
            }
            catch (ClassNotFoundException e) {
                RuntimeAssertionError.unreachable("Shared classloader initialization missing entry: " + name);
            }
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        boolean shouldResolve = resolve;
        if (name.contains("u.")) {
            RuntimeAssertionError.unreachable("FAILED: Shared classloader receive request of: " + name);
        }
        if (name.startsWith("a.") || name.startsWith("w.")) {
            Map<String, Class<?>> map = this.cacheDynamic;
            synchronized (map) {
                if (this.cacheDynamic.containsKey(name)) {
                    result = this.cacheDynamic.get(name);
                    shouldResolve = false;
                } else {
                    for (Function<String, byte[]> handler : this.handlers) {
                        byte[] code = handler.apply(name);
                        if (code == null) continue;
                        result = this.defineClass(name, code, 0, code.length);
                        this.cacheDynamic.putIfAbsent(name, result);
                        break;
                    }
                }
            }
        } else if (!this.initialized) {
            if (this.cacheStatic.containsKey(name)) {
                result = this.cacheStatic.get(name);
                shouldResolve = false;
            } else if (this.bytecodeMap.containsKey(name)) {
                byte[] injected = this.bytecodeMap.get(name);
                result = this.defineClass(name, injected, 0, injected.length);
                this.cacheStatic.putIfAbsent(name, result);
            } else {
                result = this.getParent().loadClass(name);
                shouldResolve = false;
                this.cacheStatic.putIfAbsent(name, result);
            }
        } else if (this.cacheStatic.containsKey(name)) {
            result = this.cacheStatic.get(name);
            shouldResolve = false;
        } else {
            result = this.getParent().loadClass(name);
            shouldResolve = false;
        }
        if (null != result && shouldResolve) {
            this.resolveClass(result);
        }
        return result;
    }
}

