/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.dappreading;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.aion.avm.utilities.Utilities;

public class LoadedJar {
    private static final int MAX_CLASS_BYTES = 0x100000;
    public final Map<String, byte[]> classBytesByQualifiedNames;
    public final String mainClassName;

    public static LoadedJar fromBytes(byte[] jar) throws IOException {
        LoadedJar loadedJar;
        ByteArrayInputStream byteReader = new ByteArrayInputStream(jar);
        try {
            loadedJar = LoadedJar.safeLoadFromBytes(byteReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SecurityException e) {
                throw new IOException(e.getMessage());
            }
            catch (SizeException e) {
                throw new ZipException(e.getMessage());
            }
        }
        byteReader.close();
        return loadedJar;
    }

    private static LoadedJar safeLoadFromBytes(ByteArrayInputStream byteReader) throws IOException, SizeException {
        HashMap<String, byte[]> classBytesByQualifiedNames = new HashMap<String, byte[]>();
        String mainClassName = null;
        try (JarInputStream jarReader = new JarInputStream((InputStream)byteReader, true);){
            Attributes mainAttributes;
            Manifest manifest = jarReader.getManifest();
            if (null != manifest && null != (mainAttributes = manifest.getMainAttributes())) {
                mainClassName = mainAttributes.getValue(Attributes.Name.MAIN_CLASS);
            }
            JarEntry entry = null;
            byte[] tempReadingBuffer = new byte[0x100000];
            while (null != (entry = jarReader.getNextJarEntry())) {
                String name = entry.getName();
                if (!name.endsWith(".class") || name.equals("package-info.class") || name.equals("module-info.class")) continue;
                String internalClassName = name.replaceAll(".class$", "");
                String qualifiedClassName = Utilities.internalNameToFullyQualifiedName(internalClassName);
                int readSize = jarReader.readNBytes(tempReadingBuffer, 0, tempReadingBuffer.length);
                byte[] classBytes = new byte[readSize];
                if (0 != jarReader.available()) {
                    throw new SizeException(name);
                }
                System.arraycopy(tempReadingBuffer, 0, classBytes, 0, readSize);
                classBytesByQualifiedNames.put(qualifiedClassName, classBytes);
            }
        }
        return new LoadedJar(classBytesByQualifiedNames, mainClassName);
    }

    public LoadedJar(Map<String, byte[]> classBytesByQualifiedNames, String mainClassName) {
        this.classBytesByQualifiedNames = Collections.unmodifiableMap(classBytesByQualifiedNames);
        this.mainClassName = mainClassName;
    }

    private static class SizeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SizeException(String entryName) {
            super("Class file too big: " + entryName);
        }
    }
}

