/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.instrument;

import i.RuntimeAssertionError;
import java.util.List;
import java.util.Map;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.instrument.BasicBlock;
import org.aion.avm.core.instrument.BlockBuildingMethodVisitor;
import org.aion.avm.core.instrument.BytecodeFeeScheduler;
import org.aion.avm.core.instrument.ChargeEnergyInjectionVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

public class ClassMetering
extends ClassToolchain.ToolChainClassVisitor {
    private Map<String, Integer> objectSizes;
    private final BytecodeFeeScheduler bytecodeFeeScheduler;

    public ClassMetering(Map<String, Integer> objectSizes) {
        super(458752);
        this.objectSizes = objectSizes;
        this.bytecodeFeeScheduler = new BytecodeFeeScheduler();
        this.bytecodeFeeScheduler.initialize();
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        final MethodVisitor realVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodNode(458752, access, name, descriptor, signature, exceptions){

            public void visitEnd() {
                super.visitEnd();
                BlockBuildingMethodVisitor readingVisitor = new BlockBuildingMethodVisitor();
                this.accept(readingVisitor);
                List<BasicBlock> blocks = readingVisitor.getBlockList();
                for (BasicBlock block : blocks) {
                    long feeForBlock = ClassMetering.this.calculateBlockFee(block);
                    block.setEnergyCost(feeForBlock);
                }
                ChargeEnergyInjectionVisitor instrumentingVisitor = new ChargeEnergyInjectionVisitor(realVisitor, blocks);
                this.accept(instrumentingVisitor);
            }
        };
    }

    private long calculateBlockFee(BasicBlock block) {
        long blockFee = 0L;
        long heapSize = 0L;
        for (Integer opcode : block.opcodeSequence) {
            blockFee += this.bytecodeFeeScheduler.getFee(opcode);
        }
        for (String allocationType : block.allocatedTypes) {
            if (this.objectSizes == null) continue;
            if (this.objectSizes.containsKey(allocationType)) {
                heapSize += (long)this.objectSizes.get(allocationType).intValue();
                continue;
            }
            throw RuntimeAssertionError.unreachable("Class metering size dict missing : " + allocationType);
        }
        return blockFee += heapSize * (long)BytecodeFeeScheduler.BytecodeEnergyLevels.MEMORY.getVal();
    }
}

