/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.IObjectDeserializer;
import i.RuntimeAssertionError;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.aion.avm.core.persistence.IGlobalResolver;
import org.aion.avm.core.persistence.IPersistenceNameMapper;
import org.aion.avm.core.persistence.SortedFieldCache;

public class ByteBufferObjectDeserializer
implements IObjectDeserializer {
    private final ByteBuffer buffer;
    private final SortedFieldCache cache;
    private final IGlobalResolver resolver;
    private final IPersistenceNameMapper classNameMapper;
    private final List<Object> instanceList;

    public ByteBufferObjectDeserializer(ByteBuffer buffer, List<Object> instanceList, SortedFieldCache cache, IGlobalResolver resolver, IPersistenceNameMapper classNameMapper) {
        this.buffer = buffer;
        this.cache = cache;
        this.resolver = resolver;
        this.classNameMapper = classNameMapper;
        this.instanceList = instanceList;
    }

    @Override
    public boolean readBoolean() {
        return 1 == this.buffer.get();
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public char readChar() {
        return this.buffer.getChar();
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.buffer.getInt());
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.buffer.getLong());
    }

    @Override
    public void readByteArray(byte[] result) {
        this.buffer.get(result);
    }

    @Override
    public Object readObject() {
        byte refType = this.buffer.get();
        Object result = null;
        switch (refType) {
            case 0: {
                result = null;
                break;
            }
            case 1: {
                String internalClassName = this.internalReadClassName();
                result = null != this.instanceList ? this.resolver.getClassObjectForInternalName(internalClassName) : null;
                break;
            }
            case 2: {
                int constantIdentifier = this.buffer.getInt();
                result = null != this.instanceList ? this.resolver.getConstantForIdentifier(constantIdentifier) : null;
                break;
            }
            case 3: {
                int instanceIndex = this.buffer.getInt();
                result = null != this.instanceList ? this.instanceList.get(instanceIndex) : null;
                break;
            }
            default: {
                throw RuntimeAssertionError.unreachable("Unknown byte");
            }
        }
        return result;
    }

    @Override
    public String readClassName() {
        return this.internalReadClassName();
    }

    @Override
    public void automaticallyDeserializeFromRoot(Class<?> rootClass, Object instance) {
        this.internalDeserializeFieldsFromRoot(rootClass, instance.getClass(), instance);
    }

    private void internalDeserializeFieldsFromRoot(Class<?> rootClass, Class<?> thisClass, Object instance) {
        if (rootClass != thisClass) {
            this.internalDeserializeFieldsFromRoot(rootClass, thisClass.getSuperclass(), instance);
            try {
                Field[] fields;
                for (Field field : fields = this.cache.getInstanceFields(thisClass)) {
                    Class<?> type = field.getType();
                    if (Boolean.TYPE == type) {
                        boolean val = this.readBoolean();
                        field.setBoolean(instance, val);
                        continue;
                    }
                    if (Byte.TYPE == type) {
                        byte val = this.readByte();
                        field.setByte(instance, val);
                        continue;
                    }
                    if (Short.TYPE == type) {
                        short val = this.readShort();
                        field.setShort(instance, val);
                        continue;
                    }
                    if (Character.TYPE == type) {
                        char val = this.readChar();
                        field.setChar(instance, val);
                        continue;
                    }
                    if (Integer.TYPE == type) {
                        int val = this.readInt();
                        field.setInt(instance, val);
                        continue;
                    }
                    if (Float.TYPE == type) {
                        float val = this.readFloat();
                        field.setFloat(instance, val);
                        continue;
                    }
                    if (Long.TYPE == type) {
                        long val = this.readLong();
                        field.setLong(instance, val);
                        continue;
                    }
                    if (Double.TYPE == type) {
                        double val = this.readDouble();
                        field.setDouble(instance, val);
                        continue;
                    }
                    Object val = this.readObject();
                    field.set(instance, val);
                }
            }
            catch (IllegalAccessException e) {
                throw RuntimeAssertionError.unexpected(e);
            }
        }
    }

    private String internalReadClassName() {
        int length = 0xFF & this.buffer.get();
        RuntimeAssertionError.assertTrue(length > 0);
        byte[] utf8 = new byte[length];
        this.buffer.get(utf8);
        String storageClassName = new String(utf8, StandardCharsets.UTF_8);
        return this.classNameMapper.getInternalClassName(storageClassName);
    }
}

