/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import foundation.icon.ee.score.ScoreClass;
import foundation.icon.ee.types.DAppRuntimeState;
import foundation.icon.ee.types.IllegalFormatException;
import foundation.icon.ee.types.Method;
import foundation.icon.ee.types.ObjectGraph;
import foundation.icon.ee.types.UnknownFailureException;
import foundation.icon.ee.util.MethodUnpacker;
import foundation.icon.ee.util.Shadower;
import foundation.icon.ee.util.Unshadower;
import i.AvmThrowable;
import i.IBlockchainRuntime;
import i.IInstrumentation;
import i.IObjectDeserializer;
import i.IObjectSerializer;
import i.IRuntimeSetup;
import i.InternedClasses;
import i.RuntimeAssertionError;
import i.UncaughtException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aion.avm.NameStyle;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.ClassRenamerBuilder;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.persistence.Deserializer;
import org.aion.avm.core.persistence.Serializer;
import org.aion.avm.core.persistence.SortedFieldCache;
import org.aion.avm.core.persistence.StandardGlobalResolver;
import org.aion.avm.core.persistence.StandardNameMapper;
import org.aion.avm.core.types.CommonType;
import org.aion.avm.core.util.DebugNameResolver;
import p.score.Context;
import s.java.lang.Object;

public class LoadedDApp {
    private static final String METHOD_PREFIX = "avm_";
    private static final java.lang.reflect.Method SERIALIZE_SELF;
    private static final java.lang.reflect.Method DESERIALIZE_SELF;
    private static final Field FIELD_READ_INDEX;
    public final ClassLoader loader;
    private final Class<?>[] sortedUserClasses;
    private final Class<?> constantClass;
    private final String originalMainClassName;
    private final SortedFieldCache fieldCache;
    private final Map<String, java.lang.reflect.Method> nameToMethod;
    private Constructor<?> ctor = null;
    public final IRuntimeSetup runtimeSetup;
    private Class<?> blockchainRuntimeClass;
    private Class<?> mainClass;
    private Field runtimeBlockchainRuntimeField;
    private final InternedClasses internedClasses;
    private final ClassRenamer classRenamer;
    private final boolean preserveDebuggability;
    private java.lang.Object mainInstance;
    private DAppRuntimeState stateCache;

    public LoadedDApp(ClassLoader loader, Class<?>[] userClasses, Class<?> constantClass, String originalMainClassName, byte[] apis, boolean preserveDebuggability) {
        this.loader = loader;
        this.sortedUserClasses = (Class[])Arrays.stream(userClasses).sorted(Comparator.comparing(Class::getName)).toArray(Class[]::new);
        this.constantClass = constantClass;
        this.originalMainClassName = originalMainClassName;
        this.fieldCache = new SortedFieldCache(this.loader, SERIALIZE_SELF, DESERIALIZE_SELF, FIELD_READ_INDEX);
        this.preserveDebuggability = preserveDebuggability;
        HashSet<String> postRenameUserClasses = new HashSet<String>();
        for (Class<?> userClass : this.sortedUserClasses) {
            String className = userClass.getName();
            if (className.startsWith("e.")) continue;
            postRenameUserClasses.add(className);
        }
        this.classRenamer = new ClassRenamerBuilder(NameStyle.DOT_NAME, this.preserveDebuggability).loadPostRenameUserDefinedClasses(postRenameUserClasses).loadPreRenameJclExceptionClasses(this.fetchPreRenameSlashStyleJclExceptions()).prohibitExceptionWrappers().prohibitUnifyingArrayTypes().build();
        try {
            String helperClassName = "H";
            Class<?> helperClass = this.loader.loadClass(helperClassName);
            RuntimeAssertionError.assertTrue(helperClass.getClassLoader() == this.loader);
            this.runtimeSetup = (IRuntimeSetup)helperClass.getConstructor(new Class[0]).newInstance(new java.lang.Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
        this.internedClasses = new InternedClasses();
        this.nameToMethod = new HashMap<String, java.lang.reflect.Method>();
        try {
            Method[] methods = MethodUnpacker.readFrom(apis);
            ScoreClass sc = new ScoreClass(this.loadMainClass());
            for (Method m : methods) {
                if (m.getType() == 2) continue;
                if (m.getName().equals("<init>")) {
                    this.ctor = sc.findConstructor(m);
                    continue;
                }
                java.lang.reflect.Method found = sc.findMethod(m);
                if (found == null || (found.getModifiers() & 8) != 0 || (found.getModifiers() & 1) == 0) {
                    throw new IllegalFormatException("Bad external method");
                }
                this.nameToMethod.put(m.getName(), found);
            }
            if (this.ctor == null) {
                throw new IllegalFormatException("Bad constructor");
            }
        }
        catch (IOException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static IllegalFormatException fail(String fmt, java.lang.Object ... args) {
        throw new IllegalFormatException(String.format(fmt, args));
    }

    public DAppRuntimeState loadRuntimeState(IExternalState es) {
        byte[] gh;
        if (this.stateCache != null && Arrays.equals(gh = this.stateCache.getGraph().getGraphHash(), es.getObjectGraphHash())) {
            this.stateCache = new DAppRuntimeState(this.stateCache, es.getNextHash());
            return this.stateCache;
        }
        ObjectGraph graph = es.getObjectGraph();
        DAppRuntimeState rs = new DAppRuntimeState(null, graph);
        this.loadRuntimeState(rs);
        return this.saveRuntimeState(rs.getGraph().getNextHash(), 500000);
    }

    public void loadRuntimeState(DAppRuntimeState state) {
        if (this.stateCache == state) {
            return;
        }
        ByteBuffer inputBuffer = ByteBuffer.wrap(state.getGraph().getGraphData());
        List<java.lang.Object> existingObjectIndex = state.getObjects();
        StandardGlobalResolver resolver = new StandardGlobalResolver(this.internedClasses, this.loader);
        StandardNameMapper classNameMapper = new StandardNameMapper(this.classRenamer);
        java.lang.Object[] buf = new java.lang.Object[1];
        Deserializer.deserializeEntireGraph(inputBuffer, existingObjectIndex, resolver, this.fieldCache, classNameMapper, this.sortedUserClasses, this.constantClass, buf);
        this.mainInstance = buf[0];
        this.stateCache = state;
    }

    public DAppRuntimeState saveRuntimeState() {
        int hash = IInstrumentation.attachedThreadInstrumentation.get().peekNextHashCode();
        return this.saveRuntimeState(hash, 500000);
    }

    public DAppRuntimeState saveRuntimeState(int nextHashCode, int maximumSizeInBytes) {
        ByteBuffer outputBuffer = ByteBuffer.allocate(maximumSizeInBytes);
        ArrayList<java.lang.Object> out_instanceIndex = new ArrayList<java.lang.Object>();
        StandardGlobalResolver resolver = new StandardGlobalResolver(null, this.loader);
        StandardNameMapper classNameMapper = new StandardNameMapper(this.classRenamer);
        Serializer.serializeEntireGraph(outputBuffer, out_instanceIndex, null, resolver, this.fieldCache, classNameMapper, this.sortedUserClasses, this.constantClass, this.mainInstance);
        byte[] finalBytes = new byte[outputBuffer.position()];
        System.arraycopy(outputBuffer.array(), 0, finalBytes, 0, finalBytes.length);
        this.stateCache = new DAppRuntimeState(out_instanceIndex, new ObjectGraph(nextHashCode, finalBytes));
        return this.stateCache;
    }

    public void invalidateStateCache() {
        this.stateCache = null;
    }

    public boolean hasSameGraphHash(byte[] graphHash) {
        if (this.stateCache == null) {
            return false;
        }
        byte[] gh = this.stateCache.getGraph().getGraphHash();
        return Arrays.equals(gh, graphHash);
    }

    public IBlockchainRuntime attachBlockchainRuntime(IBlockchainRuntime runtime) {
        try {
            Field field = this.getBlochchainRuntimeField();
            IBlockchainRuntime previousBlockchainRuntime = (IBlockchainRuntime)field.get(null);
            field.set(null, runtime);
            return previousBlockchainRuntime;
        }
        catch (Throwable t) {
            throw RuntimeAssertionError.unexpected(t);
        }
    }

    public void initMainInstance(java.lang.Object[] params) throws AvmThrowable {
        try {
            this.mainInstance = this.ctor.newInstance(Shadower.shadowObjects(params, this.ctor.getParameterTypes()));
        }
        catch (InvocationTargetException e) {
            this.handleUncaughtException(e.getTargetException());
        }
        catch (ExceptionInInitializerError e) {
            this.handleUncaughtException(e.getException());
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalFormatException("cannot call constructor", e);
        }
        catch (IllegalArgumentException e) {
            RuntimeAssertionError.unexpected(e);
        }
    }

    public java.lang.Object callMethod(String methodName, java.lang.Object[] params) throws AvmThrowable {
        this.stateCache = null;
        try {
            java.lang.reflect.Method method = this.nameToMethod.get(methodName);
            java.lang.Object sres = method.invoke(this.mainInstance, Shadower.shadowObjects(params, method.getParameterTypes()));
            try {
                return Unshadower.unshadow(sres);
            }
            catch (IllegalArgumentException e) {
                throw new UnknownFailureException("invalid return value");
            }
        }
        catch (InvocationTargetException e) {
            this.handleUncaughtException(e.getTargetException());
        }
        catch (ExceptionInInitializerError e) {
            this.handleUncaughtException(e.getException());
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
        return null;
    }

    public void forceInitializeAllClasses() throws AvmThrowable {
        this.forceInitializeOneClass(this.constantClass);
        for (Class<?> clazz : this.sortedUserClasses) {
            this.forceInitializeOneClass(clazz);
        }
    }

    private void forceInitializeOneClass(Class<?> clazz) throws AvmThrowable {
        try {
            Class<?> initialized = Class.forName(clazz.getName(), true, this.loader);
            RuntimeAssertionError.assertTrue(clazz == initialized);
            RuntimeAssertionError.assertTrue(initialized.getClassLoader() == this.loader);
        }
        catch (ExceptionInInitializerError e) {
            this.handleUncaughtException(e.getException());
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new UnknownFailureException(e);
        }
        catch (SecurityException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }

    private void handleUncaughtException(Throwable cause) throws AvmThrowable {
        if (cause instanceof AvmThrowable) {
            throw (AvmThrowable)cause;
        }
        if (cause instanceof RuntimeException || cause instanceof Error) {
            throw new UncaughtException(cause);
        }
        if (cause instanceof e.s.java.lang.Throwable) {
            throw new UncaughtException(((e.s.java.lang.Throwable)cause).unwrap().toString(), cause);
        }
        RuntimeAssertionError.unexpected(cause);
    }

    private Class<?> loadBlockchainRuntimeClass() throws ClassNotFoundException {
        Class<?> runtimeClass = this.blockchainRuntimeClass;
        if (null == runtimeClass) {
            String runtimeClassName = Context.class.getName();
            runtimeClass = this.loader.loadClass(runtimeClassName);
            RuntimeAssertionError.assertTrue(runtimeClass.getClassLoader() == this.loader);
            this.blockchainRuntimeClass = runtimeClass;
        }
        return runtimeClass;
    }

    private Class<?> loadMainClass() throws ClassNotFoundException {
        Class<?> mainClass = this.mainClass;
        if (null == mainClass) {
            String mappedUserMainClass = DebugNameResolver.getUserPackageDotPrefix(this.originalMainClassName, this.preserveDebuggability);
            mainClass = this.loader.loadClass(mappedUserMainClass);
            RuntimeAssertionError.assertTrue(mainClass.getClassLoader() == this.loader);
            this.mainClass = mainClass;
        }
        return mainClass;
    }

    private Field getBlochchainRuntimeField() throws ClassNotFoundException, NoSuchFieldException, SecurityException {
        Field runtimeBlockchainRuntimeField = this.runtimeBlockchainRuntimeField;
        if (null == runtimeBlockchainRuntimeField) {
            Class<?> runtimeClass = this.loadBlockchainRuntimeClass();
            this.runtimeBlockchainRuntimeField = runtimeBlockchainRuntimeField = runtimeClass.getField("blockchainRuntime");
        }
        return runtimeBlockchainRuntimeField;
    }

    private Set<String> fetchPreRenameSlashStyleJclExceptions() {
        HashSet<String> jclExceptions = new HashSet<String>();
        for (CommonType type : CommonType.values()) {
            if (!type.isShadowException) continue;
            jclExceptions.add(type.dotName.substring("s.".length()).replaceAll("\\.", "/"));
        }
        return jclExceptions;
    }

    public InternedClasses getInternedClasses() {
        return this.internedClasses;
    }

    static {
        try {
            Class<Object> shadowObject = Object.class;
            SERIALIZE_SELF = shadowObject.getDeclaredMethod("serializeSelf", Class.class, IObjectSerializer.class);
            DESERIALIZE_SELF = shadowObject.getDeclaredMethod("deserializeSelf", Class.class, IObjectDeserializer.class);
            FIELD_READ_INDEX = shadowObject.getDeclaredField("readIndex");
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }
}

