/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.OutOfEnergyException;
import i.RuntimeAssertionError;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.aion.avm.core.persistence.ByteBufferObjectSerializer;
import org.aion.avm.core.persistence.IGlobalResolver;
import org.aion.avm.core.persistence.IPersistenceNameMapper;
import org.aion.avm.core.persistence.SortedFieldCache;

public class Serializer {
    public static void serializeEntireGraphAndNextHashCode(ByteBuffer outputBuffer, List<Object> out_instanceIndex, List<Integer> out_calleeToCallerIndexMap, IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, int nextHashCode, Class<?>[] sortedRoots, Class<?> constantClass) {
        outputBuffer.putInt(nextHashCode);
        Serializer.serializeEntireGraph(outputBuffer, out_instanceIndex, out_calleeToCallerIndexMap, resolver, cache, classNameMapper, sortedRoots, constantClass, null);
    }

    public static void serializeEntireGraph(ByteBuffer outputBuffer, List<Object> out_instanceIndex, List<Integer> out_calleeToCallerIndexMap, IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, Class<?>[] sortedRoots, Class<?> constantClass, Object mainInstance) {
        RuntimeAssertionError.assertTrue(ByteOrder.BIG_ENDIAN == outputBuffer.order());
        RuntimeAssertionError.assertTrue(null == out_instanceIndex || null == out_calleeToCallerIndexMap);
        LinkedList<Object> toProcessQueue = new LinkedList<Object>();
        ByteBufferObjectSerializer objectSerializer = new ByteBufferObjectSerializer(outputBuffer, toProcessQueue, cache, resolver, classNameMapper);
        if (mainInstance != null) {
            objectSerializer.writeObject(mainInstance);
        }
        Serializer.serializeClassStatics(objectSerializer, cache, sortedRoots, constantClass);
        Serializer.serializeGraphFromWorkQueue(out_instanceIndex, out_calleeToCallerIndexMap, objectSerializer, cache, toProcessQueue);
    }

    public static void serializeObject(ByteBuffer outputBuffer, Object val, IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper) {
        RuntimeAssertionError.assertTrue(ByteOrder.BIG_ENDIAN == outputBuffer.order());
        LinkedList<Object> toProcessQueue = new LinkedList<Object>();
        ByteBufferObjectSerializer objectSerializer = new ByteBufferObjectSerializer(outputBuffer, toProcessQueue, cache, resolver, classNameMapper);
        objectSerializer.writeObject(val);
        Serializer.serializeGraphFromWorkQueue(null, null, objectSerializer, cache, toProcessQueue);
    }

    private static void serializeClassStatics(ByteBufferObjectSerializer objectSerializer, SortedFieldCache cache, Class<?>[] sortedRoots, Class<?> constantClass) {
        try {
            Serializer.serializeConstantClass(objectSerializer, cache, constantClass);
            for (Class<?> clazz : sortedRoots) {
                Serializer.serializeOneUserClass(objectSerializer, cache, clazz);
            }
        }
        catch (BufferOverflowException e) {
            throw new OutOfEnergyException();
        }
    }

    private static void serializeConstantClass(ByteBufferObjectSerializer objectSerializer, SortedFieldCache cache, Class<?> clazz) {
        Field[] constants = cache.getConstantFields(clazz);
        Serializer.serializeFieldsForClass(objectSerializer, constants);
    }

    private static void serializeOneUserClass(ByteBufferObjectSerializer objectSerializer, SortedFieldCache cache, Class<?> clazz) {
        Field[] fields = cache.getUserStaticFields(clazz);
        Serializer.serializeFieldsForClass(objectSerializer, fields);
    }

    private static void serializeGraphFromWorkQueue(List<Object> out_instanceIndex, List<Integer> out_calleeToCallerIndexMap, ByteBufferObjectSerializer objectSerializer, SortedFieldCache cache, Queue<Object> toProcessQueue) {
        Method serializeSelfMethod = cache.getSerializeSelfMethod();
        Field readIndexField = cache.getReadIndexField();
        try {
            while (!toProcessQueue.isEmpty()) {
                Object instance = toProcessQueue.remove();
                String internalClassName = instance.getClass().getName();
                objectSerializer.writeClassName(internalClassName);
                serializeSelfMethod.invoke(instance, null, objectSerializer);
                if (null != out_instanceIndex) {
                    out_instanceIndex.add(instance);
                    continue;
                }
                if (null == out_calleeToCallerIndexMap) continue;
                int readIndex = readIndexField.getInt(instance);
                out_calleeToCallerIndexMap.add(readIndex);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OutOfEnergyException) {
                throw (OutOfEnergyException)cause;
            }
            if (cause instanceof BufferOverflowException) {
                throw new OutOfEnergyException();
            }
            throw RuntimeAssertionError.unexpected(e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }

    private static void serializeFieldsForClass(ByteBufferObjectSerializer objectSerializer, Field[] fields) {
        try {
            for (Field field : fields) {
                Class<?> type = field.getType();
                if (Boolean.TYPE == type) {
                    boolean val = field.getBoolean(null);
                    objectSerializer.writeBoolean(val);
                    continue;
                }
                if (Byte.TYPE == type) {
                    byte val = field.getByte(null);
                    objectSerializer.writeByte(val);
                    continue;
                }
                if (Short.TYPE == type) {
                    short val = field.getShort(null);
                    objectSerializer.writeShort(val);
                    continue;
                }
                if (Character.TYPE == type) {
                    char val = field.getChar(null);
                    objectSerializer.writeChar(val);
                    continue;
                }
                if (Integer.TYPE == type) {
                    int val = field.getInt(null);
                    objectSerializer.writeInt(val);
                    continue;
                }
                if (Float.TYPE == type) {
                    float actual = field.getFloat(null);
                    objectSerializer.writeFloat(actual);
                    continue;
                }
                if (Long.TYPE == type) {
                    long val = field.getLong(null);
                    objectSerializer.writeLong(val);
                    continue;
                }
                if (Double.TYPE == type) {
                    double actual = field.getDouble(null);
                    objectSerializer.writeDouble(actual);
                    continue;
                }
                Object target = field.get(null);
                objectSerializer.writeObject(target);
            }
        }
        catch (IllegalAccessException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }
}

