/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.ConstantToken;
import i.InternedClasses;
import i.RuntimeAssertionError;
import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.core.persistence.IGlobalResolver;
import s.java.lang.Class;
import s.java.lang.Object;

public class StandardGlobalResolver
implements IGlobalResolver {
    private final InternedClasses internedClassMap;
    private final ClassLoader classLoader;

    public StandardGlobalResolver(InternedClasses internedClassMap, ClassLoader classLoader) {
        this.internedClassMap = internedClassMap;
        this.classLoader = classLoader;
    }

    @Override
    public String getAsInternalClassName(java.lang.Object target) {
        return target instanceof Class ? ((Class)target).getRealClass().getName() : null;
    }

    @Override
    public java.lang.Object getClassObjectForInternalName(String internalClassName) {
        try {
            java.lang.Class<?> underlyingClass = this.classLoader.loadClass(internalClassName);
            Class<?> internedClass = this.internedClassMap.get(underlyingClass);
            return internedClass;
        }
        catch (ClassNotFoundException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }

    @Override
    public int getAsConstant(java.lang.Object target) {
        int constant = 0;
        RuntimeAssertionError.assertTrue(target instanceof Object);
        if (((Object)target).readIndex < -1) {
            constant = ConstantToken.getConstantIdFromReadIndex(((Object)target).readIndex);
        }
        return constant;
    }

    @Override
    public java.lang.Object getConstantForIdentifier(int constantIdentifier) {
        return NodeEnvironment.singleton.getConstantMap().get(constantIdentifier);
    }
}

