/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.rejection;

import i.RuntimeAssertionError;
import java.util.HashMap;
import java.util.Map;
import org.aion.avm.core.rejection.RejectedClassException;

public class InstanceVariableCountManager {
    private final Map<String, Integer> nameToDeclaredCount = new HashMap<String, Integer>();
    private final Map<String, String> nameToSuperClassName = new HashMap<String, String>();

    public void addCount(String className, String superClassName, int count) {
        this.nameToDeclaredCount.put(className, count);
        this.nameToSuperClassName.put(className, superClassName);
    }

    public void verifyAllCounts() {
        HashMap<String, Integer> cache = new HashMap<String, Integer>();
        for (String className : this.nameToDeclaredCount.keySet()) {
            int thisSize = this.populateAndCacheSize(cache, className);
            if (thisSize > 31) {
                throw RejectedClassException.tooManyInstanceVariables(className);
            }
            RuntimeAssertionError.assertTrue(cache.containsKey(className));
        }
    }

    private int populateAndCacheSize(Map<String, Integer> cache, String className) {
        int size = 0;
        String superClassName = this.nameToSuperClassName.get(className);
        if (null != superClassName) {
            if (cache.containsKey(className)) {
                size = cache.get(className);
            } else {
                int parentSize = this.populateAndCacheSize(cache, superClassName);
                size = parentSize + this.nameToDeclaredCount.get(className);
                cache.put(className, size);
            }
        }
        return size;
    }
}

