/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.shadowing;

import i.IObject;
import i.RuntimeAssertionError;
import java.util.stream.Stream;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.shadowing.IObjectReplacer;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassShadowing
extends ClassToolchain.ToolChainClassVisitor {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private final String shadowPackage;
    private final IObjectReplacer replacer;
    private final String postRenameJavaLangObject;

    public ClassShadowing(String shadowPackage) {
        super(458752);
        this.shadowPackage = shadowPackage;
        this.replacer = new IObjectReplacer(shadowPackage);
        this.postRenameJavaLangObject = shadowPackage + JAVA_LANG_OBJECT;
    }

    public boolean isJdkClass(String slashClassName) {
        return slashClassName.startsWith(this.shadowPackage);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean isInterface;
        RuntimeAssertionError.assertTrue(!this.isJdkClass(name));
        boolean bl = isInterface = 0 != (0x200 & access);
        String newSuperName = isInterface ? (this.postRenameJavaLangObject.equals(superName) ? JAVA_LANG_OBJECT : superName) : superName;
        Stream<String> replacedInterfaces = Stream.of(interfaces).map(oldName -> this.replacer.replaceType((String)oldName, true));
        if (isInterface) {
            String rootInterfaceName = Utilities.fullyQualifiedNameToInternalName(IObject.class.getName());
            replacedInterfaces = Stream.concat(replacedInterfaces, Stream.of(rootInterfaceName));
        }
        String[] newInterfaces = (String[])replacedInterfaces.toArray(String[]::new);
        int newAccess = 0xFFFFBFFF & access;
        super.visit(version, newAccess, name, null, newSuperName, newInterfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, this.replacer.replaceMethodDescriptor(descriptor), null, exceptions);
        return new MethodVisitor(458752, mv){

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                if (184 == opcode && "H".equals(owner)) {
                    super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                } else {
                    boolean allowInterfaceReplacement = 183 != opcode;
                    boolean newIsInterface = ClassShadowing.this.postRenameJavaLangObject.equals(owner) ? allowInterfaceReplacement : isInterface;
                    int newOpcode = newIsInterface && 182 == opcode ? 185 : opcode;
                    String newOwner = ClassShadowing.this.replacer.replaceType(owner, allowInterfaceReplacement);
                    super.visitMethodInsn(newOpcode, newOwner, name, ClassShadowing.this.replacer.replaceMethodDescriptor(descriptor), newIsInterface);
                }
            }

            public void visitTypeInsn(int opcode, String type) {
                if (opcode != 187) {
                    super.visitTypeInsn(opcode, ClassShadowing.this.replacer.replaceType(type, true));
                } else {
                    super.visitTypeInsn(opcode, type);
                }
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                String newOwner = ClassShadowing.this.replacer.replaceType(owner, true);
                String newDescriptor = ClassShadowing.this.replacer.replaceMethodDescriptor(descriptor);
                super.visitFieldInsn(opcode, newOwner, name, newDescriptor);
            }

            public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(name, ClassShadowing.this.replacer.replaceMethodDescriptor(descriptor), signature, start, end, index);
            }
        };
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        String newDescriptor = this.replacer.replaceMethodDescriptor(descriptor);
        return super.visitField(access, name, newDescriptor, null, value);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        int newAccess = 0xFFFFBFFF & access;
        super.visitInnerClass(name, outerName, innerName, newAccess);
    }
}

