/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aion.avm.core.dappreading.LoadedJar;
import org.aion.avm.core.types.ClassInfoVisitor;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.CommonType;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class ClassInformationFactory {
    public Set<ClassInformation> fromUserDefinedPreRenameJar(LoadedJar jar) {
        if (jar == null) {
            throw new NullPointerException("Cannot derive class information from a null jar.");
        }
        HashSet<ClassInformation> classInfos = new HashSet<ClassInformation>();
        Map<String, byte[]> classNameToBytes = jar.classBytesByQualifiedNames;
        for (Map.Entry<String, byte[]> classNameToBytesEntry : classNameToBytes.entrySet()) {
            classInfos.add(this.fromClassBytes(classNameToBytesEntry.getValue(), false));
        }
        return classInfos;
    }

    public Set<ClassInformation> fromPostRenameJar(LoadedJar jar) {
        if (jar == null) {
            throw new NullPointerException("Cannot derive class information from a null jar.");
        }
        HashSet<ClassInformation> classInfos = new HashSet<ClassInformation>();
        Map<String, byte[]> classNameToBytes = jar.classBytesByQualifiedNames;
        for (Map.Entry<String, byte[]> classNameToBytesEntry : classNameToBytes.entrySet()) {
            String className = classNameToBytesEntry.getKey();
            if (className.equals(CommonType.JAVA_LANG_OBJECT.dotName) || className.equals(CommonType.I_OBJECT.dotName) || className.equals(CommonType.SHADOW_OBJECT.dotName)) continue;
            classInfos.add(this.fromClassBytes(classNameToBytesEntry.getValue(), true));
        }
        return classInfos;
    }

    public Set<ClassInformation> fromPreRenameUserDefinedBytecode(Map<String, byte[]> classNameToBytecode, boolean preserveDebuggability) throws ClassNotFoundException {
        HashSet<ClassInformation> preRenameClassInfos = new HashSet<ClassInformation>();
        for (Map.Entry<String, byte[]> classNameToBytecodeEntry : classNameToBytecode.entrySet()) {
            RuntimeAssertionError.assertTrue(!classNameToBytecodeEntry.getKey().contains("/"));
            Class<?> loadedClass = this.getClass().getClassLoader().loadClass(classNameToBytecodeEntry.getKey());
            boolean isInterface = loadedClass.isInterface();
            String superClass = this.getConcreteSuperClass(loadedClass);
            String[] superInterfaces = this.getInterfaces(loadedClass);
            if (superClass == null && (superInterfaces == null || superInterfaces.length == 0)) {
                if (preserveDebuggability) {
                    if (isInterface) {
                        superInterfaces = new String[]{CommonType.I_OBJECT.dotName};
                    } else {
                        superClass = CommonType.SHADOW_OBJECT.dotName;
                    }
                } else {
                    superClass = CommonType.JAVA_LANG_OBJECT.dotName;
                }
            }
            preRenameClassInfos.add(ClassInformation.preRenameInfoFor(isInterface, loadedClass.getName(), superClass, superInterfaces));
        }
        return preRenameClassInfos;
    }

    private String getConcreteSuperClass(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        return superClass == null ? null : superClass.getName();
    }

    private String[] getInterfaces(Class<?> clazz) {
        Class<?>[] interfacesAsClasses = clazz.getInterfaces();
        String[] interfaces = new String[interfacesAsClasses.length];
        for (int i = 0; i < interfacesAsClasses.length; ++i) {
            interfaces[i] = interfacesAsClasses[i].getName();
        }
        return interfaces;
    }

    private ClassInformation fromClassBytes(byte[] classBytes, boolean isRenamed) {
        ClassReader reader = new ClassReader(classBytes);
        ClassInfoVisitor codeVisitor = new ClassInfoVisitor(isRenamed);
        reader.accept((ClassVisitor)codeVisitor, 4);
        return codeVisitor.getClassInfo();
    }
}

