/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.util;

import i.RuntimeAssertionError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aion.avm.core.arraywrapping.ArrayNameMapper;
import org.aion.avm.core.classloading.AvmSharedClassLoader;
import org.aion.avm.utilities.Utilities;

public class MethodDescriptorCollector {
    private static final List<String> omittedClassNames = new ArrayList<String>(Arrays.asList("java/lang/invoke/MethodHandles", "java/lang/invoke/MethodHandle", "java/lang/invoke/MethodType", "java/lang/invoke/CallSite", "java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/LambdaMetafactory", "java/lang/invoke/StringConcatFactory"));

    public static List<String> getOmittedClassNames() {
        return omittedClassNames;
    }

    public static Map<String, List<String>> getClassNameMethodDescriptorMap(List<String> jclClassList, AvmSharedClassLoader classLoader) throws ClassNotFoundException {
        HashMap<String, List<String>> allowlistClassMethodMap = new HashMap<String, List<String>>();
        jclClassList.removeAll(omittedClassNames);
        jclClassList.replaceAll(s -> "s/" + s);
        for (String className : jclClassList) {
            Class<?> c = classLoader.loadClass(Utilities.internalNameToFullyQualifiedName(className), true);
            List methodList = Stream.of(c.getDeclaredConstructors()).filter(MethodDescriptorCollector::hasValidParameterType).map(MethodDescriptorCollector::buildMethodNameDescriptorString).collect(Collectors.toList());
            methodList.addAll(Stream.of(c.getMethods()).filter(method -> MethodDescriptorCollector.hasAvmMethodPrefix(method) && MethodDescriptorCollector.hasValidParameterType(method)).map(MethodDescriptorCollector::buildMethodNameDescriptorString).collect(Collectors.toList()));
            allowlistClassMethodMap.put(c.getName(), Collections.unmodifiableList(methodList));
        }
        return allowlistClassMethodMap;
    }

    public static String buildMethodNameDescriptorString(String methodName, String methodDescriptor) {
        String methodDescriptorWithoutReturnType = methodDescriptor.substring(0, methodDescriptor.lastIndexOf(41) + 1);
        return MethodDescriptorCollector.buildMethodDescriptorMapValue(methodName, methodDescriptorWithoutReturnType);
    }

    public static String buildMethodNameDescriptorString(Executable method) {
        String methodName = MethodDescriptorCollector.getMethodName(method);
        String descriptorString = MethodDescriptorCollector.buildDescriptorStringForParameters(method.getParameterTypes());
        return MethodDescriptorCollector.buildMethodDescriptorMapValue(methodName, descriptorString);
    }

    private static String buildDescriptorStringForParameters(Class<?>[] parameterTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Class<?> param : parameterTypes) {
            MethodDescriptorCollector.writeClass(builder, param);
        }
        builder.append(')');
        return builder.toString();
    }

    private static String buildMethodDescriptorMapValue(String methodName, String methodDescriptorWithoutReturnType) {
        return methodName + methodDescriptorWithoutReturnType;
    }

    private static String getMethodName(Executable method) {
        if (method instanceof Constructor) {
            RuntimeAssertionError.assertTrue(!Modifier.isStatic(method.getModifiers()));
            return "<init>";
        }
        return method.getName();
    }

    private static boolean hasValidParameterType(Executable method) {
        for (Class<?> c : method.getParameterTypes()) {
            if (MethodDescriptorCollector.isShadowClass(c.getName()) || MethodDescriptorCollector.isArrayWrapperClass(c.getName()) || MethodDescriptorCollector.isPrimitive(c) || MethodDescriptorCollector.isSupportedInternalType(c.getName())) continue;
            if (method instanceof Method) {
                throw RuntimeAssertionError.unreachable("Transformed method " + method.getDeclaringClass() + "." + method.getName() + " should not have an unsupported parameter type: " + c.getName());
            }
            return false;
        }
        return true;
    }

    private static boolean isShadowClass(String className) {
        return className.startsWith("s.");
    }

    private static boolean isArrayWrapperClass(String className) {
        return className.startsWith("a.");
    }

    private static boolean isSupportedInternalType(String className) {
        return className.equals("i.IObject") || className.equals("i.IObjectArray");
    }

    private static boolean hasAvmMethodPrefix(Method method) {
        return method.getName().startsWith("avm_");
    }

    private static boolean isPrimitive(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive();
    }

    private static void writeClass(StringBuilder builder, Class<?> clazz) {
        if (clazz.isArray()) {
            builder.append('[');
            MethodDescriptorCollector.writeClass(builder, clazz.getComponentType());
        } else if (!clazz.isPrimitive()) {
            String className = clazz.getName();
            if (className.startsWith("a.")) {
                builder.append(ArrayNameMapper.getOriginalNameOf(Utilities.fullyQualifiedNameToInternalName(className)));
            } else if ("i.IObject".equals(className)) {
                builder.append('L');
                builder.append("s/java/lang/Object");
                builder.append(';');
            } else {
                builder.append('L');
                builder.append(Utilities.fullyQualifiedNameToInternalName(className));
                builder.append(';');
            }
        } else if (Byte.TYPE == clazz) {
            builder.append('B');
        } else if (Character.TYPE == clazz) {
            builder.append('C');
        } else if (Double.TYPE == clazz) {
            builder.append('D');
        } else if (Float.TYPE == clazz) {
            builder.append('F');
        } else if (Integer.TYPE == clazz) {
            builder.append('I');
        } else if (Long.TYPE == clazz) {
            builder.append('J');
        } else if (Short.TYPE == clazz) {
            builder.append('S');
        } else if (Boolean.TYPE == clazz) {
            builder.append('Z');
        } else if (Void.TYPE == clazz) {
            builder.append('V');
        } else {
            RuntimeAssertionError.unreachable("Missing descriptor type: " + clazz);
        }
    }
}

