/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.aion.avm.utilities.Utilities;

public class JarBuilder {
    private static final long FIXED_TIMESTAMP = 0L;
    private static final String APIS_NAME = "META-INF/APIS";
    private final ByteArrayOutputStream byteStream;
    private final JarOutputStream jarStream;
    private final Set<String> entriesInJar;

    private void buildJarImpl(Map<String, byte[]> classMap, Class<?> ... otherClasses) throws IOException {
        for (Map.Entry<String, byte[]> entry : classMap.entrySet()) {
            this.saveClassToStream(entry.getKey(), entry.getValue());
        }
        for (Class<?> clazz : otherClasses) {
            this.addClassAndInners(clazz);
        }
    }

    public static byte[] buildJarForExplicitClassNamesAndBytecode(String mainClassName, byte[] mainClassBytes, Map<String, byte[]> classMap, Class<?> ... otherClasses) {
        JarBuilder builder = new JarBuilder(null, mainClassName);
        try {
            builder.saveClassToStream(mainClassName, mainClassBytes);
            builder.buildJarImpl(classMap, otherClasses);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return builder.toBytes();
    }

    public static byte[] buildJarForExplicitClassNamesAndBytecode(String mainClassName, Map<String, byte[]> classMap, Class<?> ... otherClasses) {
        JarBuilder builder = new JarBuilder(null, mainClassName);
        try {
            builder.buildJarImpl(classMap, otherClasses);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return builder.toBytes();
    }

    public static byte[] buildJarForMainClassAndExplicitClassNamesAndBytecode(Class<?> mainClass, Map<String, byte[]> classMap, Class<?> ... otherClasses) {
        JarBuilder builder = new JarBuilder(mainClass, null);
        try {
            builder.buildJarImpl(classMap, otherClasses);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return builder.toBytes();
    }

    public static byte[] buildJarForExplicitMainAndClasses(String mainClassName, Class<?> ... otherClasses) {
        JarBuilder builder = new JarBuilder(null, mainClassName);
        for (Class<?> clazz : otherClasses) {
            builder.addClassAndInners(clazz);
        }
        return builder.toBytes();
    }

    public static byte[] buildJarWithApiInfo(String mainClassName, byte[] mainClassBytes, byte[] apiInfo, Map<String, byte[]> classMap) {
        JarBuilder builder = new JarBuilder(null, mainClassName, apiInfo);
        try {
            builder.saveClassToStream(mainClassName, mainClassBytes);
            for (Map.Entry<String, byte[]> entry : classMap.entrySet()) {
                builder.saveClassToStream(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return builder.toBytes();
    }

    public static byte[] getAPIsBytesFromJAR(byte[] jarBytes) throws IOException {
        try {
            JarEntry entry;
            JarInputStream jis = new JarInputStream((InputStream)new ByteArrayInputStream(jarBytes), true);
            while ((entry = jis.getNextJarEntry()) != null) {
                if (!entry.getName().equals(APIS_NAME)) continue;
                return jis.readAllBytes();
            }
            return null;
        }
        catch (EOFException | IllegalArgumentException e) {
            throw new ZipException(e.getClass().getName());
        }
    }

    private JarBuilder(Class<?> mainClass, String mainClassName) {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (null != mainClass) {
            mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClass.getName());
        } else if (null != mainClassName) {
            mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClassName);
        }
        this.byteStream = new ByteArrayOutputStream();
        JarOutputStream stream = null;
        try {
            stream = new JarOutputStream(this.byteStream);
            ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
            manifestEntry.setTime(0L);
            stream.putNextEntry(manifestEntry);
            manifest.write(stream);
            stream.closeEntry();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.jarStream = stream;
        this.entriesInJar = new HashSet<String>();
        if (null != mainClass) {
            this.addClassAndInners(mainClass);
        }
    }

    private JarBuilder(Class<?> mainClass, String mainClassName, byte[] apiInfo) {
        this(mainClass, mainClassName);
        try {
            JarEntry entry = new JarEntry(APIS_NAME);
            entry.setTime(0L);
            this.jarStream.putNextEntry(entry);
            this.jarStream.write(apiInfo);
            this.jarStream.closeEntry();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private JarBuilder addClassAndInners(Class<?> clazz) {
        try {
            this.loadClassAndAnonymous(clazz);
            for (Class<?> one : clazz.getDeclaredClasses()) {
                this.addClassAndInners(one);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    private void loadClassAndAnonymous(Class<?> clazz) throws IOException {
        String className = clazz.getName();
        byte[] bytes = Utilities.loadRequiredResourceAsBytes(Utilities.fullyQualifiedNameToInternalName(className) + ".class");
        if (null == bytes) {
            throw new AssertionError((Object)"Class bytes could not be found");
        }
        this.saveClassToStream(className, bytes);
        int i = 1;
        String innerName = className + "$" + Integer.toString(i);
        byte[] innerBytes = Utilities.loadRequiredResourceAsBytes(Utilities.fullyQualifiedNameToInternalName(innerName) + ".class");
        while (null != innerBytes) {
            this.saveClassToStream(innerName, innerBytes);
            innerName = className + "$" + Integer.toString(++i);
            innerBytes = Utilities.loadRequiredResourceAsBytes(Utilities.fullyQualifiedNameToInternalName(innerName) + ".class");
        }
    }

    private void saveClassToStream(String qualifiedClassName, byte[] bytes) throws IOException {
        String internalName = Utilities.fullyQualifiedNameToInternalName(qualifiedClassName);
        if (this.entriesInJar.contains(internalName)) {
            throw new AssertionError((Object)("Added class to JAR twice " + internalName));
        }
        JarEntry entry = new JarEntry(internalName + ".class");
        entry.setTime(0L);
        this.jarStream.putNextEntry(entry);
        this.jarStream.write(bytes);
        this.jarStream.closeEntry();
        this.entriesInJar.add(internalName);
    }

    private byte[] toBytes() {
        try {
            this.jarStream.finish();
            this.jarStream.close();
            this.byteStream.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return this.byteStream.toByteArray();
    }
}

